/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.operators.Operator;
import unity.operators.Scan;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.Optimizer;
import unity.query.SubQuery;

public class LQSubQueryNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private SubQuery sq;

    public LQSubQueryNode() {
        this.type = 17;
    }

    public SubQuery getSq() {
        return this.sq;
    }

    public void setSq(SubQuery subQuery) {
        this.sq = subQuery;
    }

    public String generateSQLNoAlias() {
        return Optimizer.buildSQL(this.sq.getLogicalQueryTree().getRoot());
    }

    @Override
    public String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('(');
        stringBuffer.append(Optimizer.buildSQL(this.sq.getLogicalQueryTree().getRoot()));
        stringBuffer.append(") ");
        GQTableRef gQTableRef = (GQTableRef)this.getContent();
        stringBuffer.append(gQTableRef.getAliasName());
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("SUBQUERY");
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        Attribute[] attributeArray = new Attribute[this.sq.getOutputFieldReferences().size()];
        Relation relation = operatorArray[0].getOutputRelation();
        Expression[] expressionArray = new Expression[attributeArray.length];
        ArrayList<GQFieldRef> arrayList = this.sq.getOutputFieldReferences();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i] = new Attribute();
            ExtractAttribute extractAttribute = new ExtractAttribute(i);
            expressionArray[i] = extractAttribute;
            Attribute attribute = relation.getAttribute(i);
            expressionArray[i].setReturnType(attribute.getType());
            attributeArray[i].setType(attribute.getType());
            attributeArray[i].setName(attribute.getName());
            attributeArray[i].setLength(attribute.getLength());
            attributeArray[i].setReference(arrayList.get(i));
        }
        this.outputRelation = new Relation(attributeArray);
        Scan scan = new Scan(operatorArray[0], this.outputRelation);
        this.setOperator(scan);
        return scan;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        HashMap<String, GQDatabaseRef> hashMap = this.getSq().getDBRefs();
        if (hashMap.size() > 1) {
            Iterator<Map.Entry<String, GQDatabaseRef>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next().getValue());
            }
        } else if (hashMap.size() > 0) {
            hashSet.add(hashMap.entrySet().iterator().next().getValue());
        }
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        this.cost = (double)l * 1.0;
        this.rows = l;
    }
}

