/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.predicates.SortComparator;

public class ExprSortComparator
extends SortComparator {
    private Expression[] expressions;

    public ExprSortComparator(Expression[] expressionArray, boolean[] blArray) {
        this.expressions = expressionArray;
        this.sortAsc = blArray;
        this.numAttrs = expressionArray.length;
    }

    @Override
    public int sqlcompare(Object object, Object object2) throws SQLException {
        Tuple tuple = (Tuple)object;
        Tuple tuple2 = (Tuple)object2;
        for (int i = 0; i < this.numAttrs; ++i) {
            int n;
            Comparable comparable = (Comparable)this.expressions[i].evaluate(tuple);
            Comparable comparable2 = (Comparable)this.expressions[i].evaluate(tuple2);
            if (comparable == null || comparable2 == null) {
                if (comparable == null && comparable2 == null) {
                    return 0;
                }
                n = 1;
                n = comparable == null ? -1 : 1;
                if (!this.sortAsc[i]) {
                    n = -1 * n;
                }
                return n;
            }
            n = comparable.compareTo(comparable2);
            if (this.sortAsc[i]) {
                if (n > 0) {
                    return 1;
                }
                if (n >= 0) continue;
                return -1;
            }
            if (n < 0) {
                return 1;
            }
            if (n <= 0) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Expr0");
        if (this.sortAsc[0]) {
            stringBuilder.append(" ASC");
        } else {
            stringBuilder.append(" DESC");
        }
        for (int i = 1; i < this.expressions.length; ++i) {
            stringBuilder.append(", Expr" + i);
            if (this.sortAsc[i]) {
                stringBuilder.append(" ASC");
                continue;
            }
            stringBuilder.append(" DESC");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.expressions[0].toString(relation));
        if (this.sortAsc[0]) {
            stringBuffer.append(" ASC");
        } else {
            stringBuffer.append(" DESC");
        }
        for (int i = 1; i < this.expressions.length; ++i) {
            stringBuffer.append(", " + this.expressions[i].toString(relation));
            if (this.sortAsc[i]) {
                stringBuffer.append(" ASC");
                continue;
            }
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }
}

