/*
 * Decompiled with CFR 0.152.
 */
package unity.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.util.Convert;

public class Tuple {
    protected boolean validObjects;
    protected boolean validBytes;
    protected Object[] values;
    protected byte[] data;
    protected Relation relation;
    protected boolean headerExpanded;
    protected byte firstOffset;
    protected byte offsetSize;
    protected int dataOffset;
    protected int numFields;
    protected int recordLength;
    protected byte status;
    public static final byte STATUS_CLEAR = 0;
    public static final byte STATUS_WAS_NULL = 1;
    public boolean wasNull;
    protected static final byte ID_OFFSET = 1;
    protected static final byte NEXT_OFFSET = 5;
    protected static final byte LEN_OFFSET = 9;
    protected static final byte FLAG_BIT = 5;
    protected static final byte INTEGER_RECORD_LENGTH_BIT = 4;
    protected static final byte SHORT_RECORD_LENGTH_BIT = 3;
    protected static final byte SHORT_FIELDS_LENGTH_BIT = 2;
    protected static final byte INTEGER_OFFSETS_BIT = 1;
    protected static final byte SHORT_OFFSETS_BIT = 0;

    public Tuple() {
        this.values = null;
        this.data = null;
        this.validObjects = false;
        this.validBytes = false;
        this.relation = null;
    }

    public Tuple(Relation relation) {
        this();
        this.relation = relation;
    }

    public Tuple(Object[] objectArray, Relation relation) {
        this.values = objectArray;
        this.data = null;
        this.validObjects = true;
        this.validBytes = false;
        this.relation = relation;
    }

    public Tuple(byte[] byArray, Relation relation) {
        this.data = byArray;
        this.values = null;
        this.relation = relation;
        this.validObjects = false;
        this.validBytes = true;
        this.headerExpanded = false;
    }

    public void copy(Tuple tuple) {
        this.data = tuple.data;
        this.values = tuple.values;
        this.validObjects = tuple.validObjects;
        this.validBytes = tuple.validBytes;
        this.headerExpanded = tuple.headerExpanded;
        this.relation = tuple.relation;
        this.firstOffset = tuple.firstOffset;
        this.dataOffset = tuple.dataOffset;
        this.numFields = tuple.numFields;
        this.offsetSize = tuple.offsetSize;
        this.status = tuple.status;
    }

    public Object getObject(int n) throws SQLException {
        if (this.validObjects) {
            return this.values[n];
        }
        if (this.validBytes) {
            int n2 = this.getOffset(n);
            if (n2 == 0) {
                return null;
            }
            if (this.relation == null) {
                System.out.println("HERE");
            }
            return Attribute.convertToObject(this.data, this.dataOffset + n2 - 1, this.relation.getAttributeType(n));
        }
        return null;
    }

    public int getInt(int n) throws SQLException {
        if (this.validBytes) {
            int n2 = this.getOffset(n);
            boolean bl = this.wasNull = n2 == 0;
            if (this.wasNull) {
                return 0;
            }
            return Convert.toInt(this.data, this.dataOffset + n2 - 1);
        }
        if (this.validObjects) {
            boolean bl = this.wasNull = this.values[n] == null;
            if (this.wasNull) {
                return 0;
            }
            try {
                return (Integer)this.values[n];
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
        }
        this.wasNull = true;
        return 0;
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object != null) {
            return this.getObject(n).toString();
        }
        return null;
    }

    public boolean isNull(int n) {
        if (this.validObjects) {
            return this.values[n] == null;
        }
        if (this.validBytes) {
            return this.getOffset(n) == 0;
        }
        return true;
    }

    public int getNumFields() {
        if (this.validObjects) {
            return this.values.length;
        }
        if (this.validBytes) {
            if (this.headerExpanded) {
                return this.numFields;
            }
            this.getOffset(0);
            return this.numFields;
        }
        return 0;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setId(int n) throws SQLException {
        if (!this.validBytes) {
            this.convertToBytes(this.relation);
        }
        Tuple.setId(this.data, n);
    }

    public int getId() {
        if (this.validBytes) {
            return Tuple.getId(this.data);
        }
        return 0;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte by) {
        this.status = by;
    }

    public byte[] getBytes() throws SQLException {
        if (!this.validBytes) {
            this.convertToBytes(this.relation);
        }
        return this.data;
    }

    public long getSize() throws SQLException {
        return this.getBytes().length;
    }

    public void setBytes(byte[] byArray) {
        this.data = byArray;
        this.validBytes = true;
        this.validObjects = false;
        this.headerExpanded = false;
    }

    public byte[] convertToBytes(Relation relation) throws SQLException {
        this.data = Tuple.convertToBytes(this.values, relation);
        this.validBytes = true;
        this.headerExpanded = false;
        return this.data;
    }

    public byte[] convertToBytes(int[] nArray, byte[][] byArray) throws SQLException {
        this.data = Tuple.convertToBytes(this.values, this.relation, nArray, byArray);
        this.validBytes = true;
        this.headerExpanded = false;
        return this.data;
    }

    public Object[] getValues() throws SQLException {
        if (this.validObjects) {
            return this.values;
        }
        this.values = Tuple.convertToObjects(this.data, this.relation);
        this.validObjects = true;
        return this.values;
    }

    public void setValues(Object[] objectArray) {
        this.values = objectArray;
        this.validObjects = true;
        this.validBytes = false;
        this.data = null;
    }

    public int getOffset(int n) {
        if (this.headerExpanded) {
            return this.convertOffset(n);
        }
        byte by = this.data[0];
        int n2 = 9;
        if (Convert.isBitSet(by, 4)) {
            this.recordLength = Convert.toInt(this.data, n2);
            n2 += 4;
        } else if (Convert.isBitSet(by, 3)) {
            this.recordLength = Convert.toShort(this.data, n2);
            n2 += 2;
        } else {
            this.recordLength = this.data[n2] & 0xFF;
            ++n2;
        }
        if (Convert.isBitSet(by, 2)) {
            this.numFields = Convert.toShort(this.data, n2);
            n2 += 2;
        } else {
            this.numFields = this.data[n2];
            ++n2;
        }
        this.headerExpanded = true;
        this.firstOffset = (byte)n2;
        this.offsetSize = 1;
        if (Convert.isBitSet(by, 1)) {
            this.offsetSize = (byte)4;
        } else if (Convert.isBitSet(by, 0)) {
            this.offsetSize = (byte)2;
        }
        this.dataOffset = this.firstOffset + this.numFields * this.offsetSize;
        return this.convertOffset(n);
    }

    protected int convertOffset(int n) {
        if (this.offsetSize == 1) {
            return this.data[this.firstOffset + n * this.offsetSize] & 0xFF;
        }
        if (this.offsetSize == 2) {
            return Convert.toShort(this.data, this.firstOffset + n * this.offsetSize);
        }
        return Convert.toInt(this.data, this.firstOffset + n * this.offsetSize);
    }

    public static int getNext(byte[] byArray) {
        return Convert.toInt(byArray, 5);
    }

    public static int getNext(byte[] byArray, int n) {
        return Convert.toInt(byArray, n + 5);
    }

    public static int getId(byte[] byArray) {
        return Convert.toInt(byArray, 1);
    }

    public static void setId(byte[] byArray, int n) {
        Convert.toByte(n, byArray, 1);
    }

    public static void setNext(byte[] byArray, int n) {
        Convert.toByte(n, byArray, 5);
    }

    public static void setNext(byte[] byArray, int n, int n2) {
        Convert.toByte(n2, byArray, 5 + n);
    }

    public static boolean getFlag(byte[] byArray) {
        return Convert.isBitSet(byArray[0], 5);
    }

    public static boolean getFlag(byte[] byArray, int n) {
        return Convert.isBitSet(byArray[0 + n], 5);
    }

    public static void setFlag(byte[] byArray, boolean bl) {
        byArray[0] = Convert.setBit(byArray[0], (byte)5, bl);
    }

    public static void setFlag(byte[] byArray, int n, boolean bl) {
        byArray[n + 0] = Convert.setBit(byArray[n + 0], (byte)5, bl);
    }

    public static Object[] convertToObjects(byte[] byArray, Relation relation) throws SQLException {
        int n;
        if (byArray == null) {
            return null;
        }
        byte by = byArray[0];
        int n2 = 9;
        int n3 = 0;
        if (Convert.isBitSet(by, 4)) {
            n3 = Convert.toInt(byArray, n2);
            n2 += 4;
        } else if (Convert.isBitSet(by, 3)) {
            n3 = Convert.toShort(byArray, n2);
            n2 += 2;
        } else {
            n3 = byArray[n2] & 0xFF;
            ++n2;
        }
        if (n3 != byArray.length) {
            throw new SQLException("Error reading row.  Invalid row length.");
        }
        if (Convert.isBitSet(by, 2)) {
            n = Convert.toShort(byArray, n2);
            n2 += 2;
        } else {
            n = byArray[n2];
            ++n2;
        }
        int n4 = 0;
        if (Convert.isBitSet(by, 1)) {
            n4 = 2;
        } else if (Convert.isBitSet(by, 0)) {
            n4 = 1;
        }
        Object[] objectArray = new Object[n];
        if (n4 == 0) {
            int n5 = n2 + n;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = byArray[n2 + i] == 0 ? null : Attribute.convertToObject(byArray, n5 + (byArray[n2 + i] & 0xFF) - 1, relation.getAttributeType(i));
            }
        } else if (n4 == 1) {
            int n6 = n2 + n * 2;
            for (int i = 0; i < n; ++i) {
                short s = Convert.toShort(byArray, n2 + i * 2);
                objectArray[i] = s == 0 ? null : Attribute.convertToObject(byArray, n6 + s - 1, relation.getAttributeType(i));
            }
        } else {
            int n7 = n2 + n * 4;
            for (int i = 0; i < n; ++i) {
                int n8 = Convert.toInt(byArray, n2 + i * 4);
                objectArray[i] = n8 == 0 ? null : Attribute.convertToObject(byArray, n7 + n8 - 1, relation.getAttributeType(i));
            }
        }
        return objectArray;
    }

    public static byte[] convertToBytes(Object[] objectArray, Relation relation) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        return Tuple.convertToBytes(objectArray, relation, new int[objectArray.length], new byte[objectArray.length][]);
    }

    public static byte[] convertToBytes(Object[] objectArray, Relation relation, int[] nArray, byte[][] byArray) throws SQLException {
        int n;
        int n2;
        byte by;
        if (objectArray == null) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        for (by = 0; by < objectArray.length; ++by) {
            if (objectArray[by] == null) {
                nArray[by] = 0;
                continue;
            }
            n4 = n3;
            nArray[by] = n3 + 1;
            byArray[by] = Attribute.convertToBytes(relation.getAttributeType(by), objectArray[by]);
            n3 += byArray[by].length;
        }
        by = 0;
        int n5 = 9;
        if (objectArray.length < 255) {
            ++n5;
        } else {
            by = Convert.setBit(by, (byte)2, true);
            n5 += 2;
        }
        if (n4 < 255) {
            n5 += objectArray.length;
            n2 = 0;
        } else if (n4 < 32766) {
            by = Convert.setBit(by, (byte)0, true);
            n5 += 2 * objectArray.length;
            n2 = 1;
        } else {
            by = Convert.setBit(by, (byte)1, true);
            n5 += 4 * objectArray.length;
            n2 = 2;
        }
        if ((n5 += n3) < 254) {
            ++n5;
        } else if (n5 < 32765) {
            by = Convert.setBit(by, (byte)3, true);
            n5 += 2;
        } else {
            by = Convert.setBit(by, (byte)4, true);
            n5 += 4;
        }
        byte[] byArray2 = new byte[n5];
        int n6 = 9;
        byArray2[0] = by;
        if (n5 <= 255) {
            byArray2[n6] = (byte)n5;
            ++n6;
        } else if (n5 <= Short.MAX_VALUE) {
            Convert.toByte((short)n5, byArray2, n6);
            n6 += 2;
        } else {
            Convert.toByte(n5, byArray2, n6);
            n6 += 4;
        }
        if (objectArray.length < 255) {
            byArray2[n6] = (byte)objectArray.length;
            ++n6;
        } else {
            Convert.toByte((short)objectArray.length, byArray2, n6);
            n6 += 2;
        }
        if (n2 == 0) {
            for (n = 0; n < objectArray.length; ++n) {
                byArray2[n6] = (byte)nArray[n];
                ++n6;
            }
        } else if (n2 == 1) {
            for (n = 0; n < objectArray.length; ++n) {
                Convert.toByte((short)nArray[n], byArray2, n6);
                n6 += 2;
            }
        } else {
            for (n = 0; n < objectArray.length; ++n) {
                Convert.toByte(nArray[n], byArray2, n6);
                n6 += 4;
            }
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            System.arraycopy(byArray[n], 0, byArray2, n6, byArray[n].length);
            n6 += byArray[n].length;
        }
        return byArray2;
    }

    public void mergeTuple(Tuple tuple, Tuple tuple2, Relation relation, boolean bl) throws SQLException {
        this.relation = relation;
        if (bl) {
            if (!tuple.validObjects) {
                tuple.values = Tuple.convertToObjects(tuple.getBytes(), tuple.relation);
            }
            if (!tuple2.validObjects) {
                tuple2.values = Tuple.convertToObjects(tuple2.getBytes(), tuple2.relation);
            }
            this.values = new Object[tuple.values.length + tuple2.values.length];
            System.arraycopy(tuple.values, 0, this.values, 0, tuple.values.length);
            System.arraycopy(tuple2.values, 0, this.values, tuple.values.length, tuple2.values.length);
            this.validObjects = true;
            this.validBytes = false;
        }
    }

    public String toString() {
        try {
            if (!this.validObjects && !this.validBytes) {
                return "";
            }
            if (!this.validObjects) {
                this.values = Tuple.convertToObjects(this.data, this.relation);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.values.length > 0) {
                stringBuffer.append(this.getObject(0));
            }
            for (int i = 1; i < this.values.length; ++i) {
                stringBuffer.append(", " + this.getObject(i));
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            return "TUPLE ERROR";
        }
    }

    public static Tuple generateRandomTuple(Random random, Relation relation) {
        int n = relation.getNumAttributes();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Attribute.generateRandomValueOrNull(random, relation.getAttributeType(i));
        }
        return new Tuple(objectArray, relation);
    }

    public boolean read(BufferedInputStream bufferedInputStream) throws SQLException {
        try {
            byte[] byArray;
            int n = bufferedInputStream.read();
            this.values = null;
            this.data = null;
            if (n == -1) {
                return false;
            }
            byte by = (byte)n;
            int n2 = 9;
            this.recordLength = 0;
            if (Convert.isBitSet(by, 4)) {
                byArray = new byte[12];
                bufferedInputStream.read(byArray, 0, 12);
                this.recordLength = Convert.toInt(byArray, 8);
                n2 += 4;
            } else if (Convert.isBitSet(by, 3)) {
                byArray = new byte[10];
                bufferedInputStream.read(byArray, 0, 10);
                this.recordLength = Convert.toShort(byArray, 8);
                n2 += 2;
            } else {
                byArray = new byte[9];
                bufferedInputStream.read(byArray, 0, 9);
                this.recordLength = byArray[8] & 0xFF;
                ++n2;
            }
            if (this.recordLength <= 0) {
                throw new SQLException("Invalid row length");
            }
            byte[] byArray2 = new byte[this.recordLength];
            byArray2[0] = by;
            System.arraycopy(byArray, 0, byArray2, 1, n2 - 1);
            bufferedInputStream.read(byArray2, n2, this.recordLength - n2);
            this.data = byArray2;
            this.values = null;
            this.validBytes = true;
            this.validObjects = false;
            this.headerExpanded = false;
            return true;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public boolean write(BufferedOutputStream bufferedOutputStream) throws SQLException {
        try {
            if (this.data == null || !this.validBytes) {
                this.data = Tuple.convertToBytes(this.values, this.relation);
            }
            bufferedOutputStream.write(this.data, 0, this.data.length);
            return true;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    public boolean readText(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|\t");
        int n = stringTokenizer.countTokens();
        this.values = new Object[n];
        this.validBytes = false;
        this.validObjects = true;
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            this.values[i] = string2.equals("##NULL##") ? null : ((n2 = this.relation.getAttributeType(i)) == 4 ? new Integer(Integer.parseInt(string2)) : string2);
        }
        return true;
    }

    public void writeText(PrintWriter printWriter) throws SQLException {
        if (!this.validObjects && !this.validBytes) {
            return;
        }
        if (!this.validObjects) {
            this.values = Tuple.convertToObjects(this.data, this.relation);
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object object = this.getObject(i);
            if (object == null) {
                printWriter.print("##NULL##\t");
                continue;
            }
            printWriter.print(this.getObject(i) + "\t");
        }
        printWriter.println();
    }
}

