/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.AppPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;

public class ValidatorGlobalPreferencesTab
implements IGlobalPreferencesPanel {
    private static final ILogger s_log = LoggerController.createLogger(ValidatorGlobalPreferencesTab.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ValidatorGlobalPreferencesTab.class);
    private final WebServicePreferences _prefs;
    private PrefsPanel _myPanel;
    private IApplication _app;

    public ValidatorGlobalPreferencesTab(WebServicePreferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._prefs = prefs;
    }

    public void initialize(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        ((PrefsPanel)this.getPanelComponent()).loadData();
    }

    public void uninitialize(IApplication app) {
    }

    public synchronized Component getPanelComponent() {
        if (this._myPanel == null) {
            this._myPanel = new PrefsPanel(this._prefs);
        }
        return this._myPanel;
    }

    public void applyChanges() {
        this._myPanel.save();
    }

    public String getTitle() {
        return s_stringMgr.getString("ValidatorGlobalPreferencesTab.title");
    }

    public String getHint() {
        return s_stringMgr.getString("ValidatorGlobalPreferencesTab.hint");
    }

    static final class PrefsPanel
    extends JPanel {
        private AppPreferencesPanel _appPrefsPnl;
        private final WebServicePreferences _prefs;

        PrefsPanel(WebServicePreferences prefs) {
            super(new GridBagLayout());
            this._prefs = prefs;
            this.createGUI(prefs);
        }

        private void loadData() {
            this._appPrefsPnl.loadData();
        }

        private void save() {
            this._appPrefsPnl.save();
        }

        private void createGUI(WebServicePreferences prefs) {
            this._appPrefsPnl = new AppPreferencesPanel(prefs);
            this.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.add((Component)this._appPrefsPnl, gbc);
        }
    }
}

