/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kea" locale.
 */
public class LocalizedNamesImpl_kea extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "HT",
        "AL",
        "DE",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AN",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BD",
        "BH",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EG",
        "EC",
        "SV",
        "AE",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GG",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "YE",
        "BV",
        "AC",
        "IM",
        "CX",
        "HM",
        "CP",
        "AX",
        "IO",
        "FO",
        "KY",
        "CC",
        "CK",
        "FK",
        "MP",
        "MH",
        "MU",
        "UM",
        "NF",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IQ",
        "ER",
        "IE",
        "IR",
        "IS",
        "IL",
        "IT",
        "ET",
        "JM",
        "JP",
        "GS",
        "JE",
        "GI",
        "GE",
        "JO",
        "CV",
        "CM",
        "KH",
        "KM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "KW",
        "CO",
        "CW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MG",
        "YT",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "MR",
        "MX",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "NL",
        "OM",
        "HN",
        "QO",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PR",
        "PL",
        "PT",
        "GB",
        "MO",
        "HK",
        "DO",
        "CF",
        "CZ",
        "RO",
        "RW",
        "RE",
        "RU",
        "WS",
        "AS",
        "SM",
        "PM",
        "SH",
        "LC",
        "EH",
        "BL",
        "VC",
        "KN",
        "MF",
        "SX",
        "ST",
        "SC",
        "SN",
        "SL",
        "RS",
        "EA",
        "SG",
        "SY",
        "SK",
        "SI",
        "ES",
        "LK",
        "US",
        "EE",
        "SZ",
        "SD",
        "SS",
        "SE",
        "CH",
        "SO",
        "SR",
        "SJ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "TD",
        "WF",
        "UG",
        "UA",
        "HU",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VN",
        "VE",
        "CL",
        "CN",
        "CY",
        "XK",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundu");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Merka di Norti");
    namesMap.put("005", "Merka di Sul");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Afrika Osidental");
    namesMap.put("013", "Merka Sentral");
    namesMap.put("014", "Afrika Oriental");
    namesMap.put("015", "Norti di Afrika");
    namesMap.put("017", "Afrika Sentral");
    namesMap.put("018", "Sul di Afrika");
    namesMap.put("019", "Merkas");
    namesMap.put("021", "Norti di Merka");
    namesMap.put("029", "Karaibas");
    namesMap.put("030", "Azia Oriental");
    namesMap.put("034", "Sul di Azia");
    namesMap.put("035", "Sudesti Aziatiku");
    namesMap.put("039", "Europa di Sul");
    namesMap.put("053", "Australazia");
    namesMap.put("054", "Melanezia");
    namesMap.put("057", "Rejiãu di Mikronezia");
    namesMap.put("061", "Polinezia");
    namesMap.put("142", "Azia");
    namesMap.put("143", "Azia Sentral");
    namesMap.put("145", "Azia Osidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa di Norti");
    namesMap.put("155", "Europa Osidental");
    namesMap.put("419", "Merka Latinu");
    namesMap.put("AC", "Ilha di Asensãu");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Emiradus Arabi Unidu");
    namesMap.put("AF", "Afeganistãu");
    namesMap.put("AG", "Antigua i Barbuda");
    namesMap.put("AI", "Angila");
    namesMap.put("AN", "Antilhas Olandeza");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AR", "Arjentina");
    namesMap.put("AS", "Samoa Merkanu");
    namesMap.put("AX", "Ilhas Åland");
    namesMap.put("AZ", "Azerbaijãu");
    namesMap.put("BA", "Bosnia-Erzegovina");
    namesMap.put("BB", "Barbadus");
    namesMap.put("BD", "Bangladexi");
    namesMap.put("BE", "Béljika");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BH", "Barain");
    namesMap.put("BL", "Sãu Bartolomeu");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BQ", "Karaibas olandes");
    namesMap.put("BS", "Baamas");
    namesMap.put("BT", "Butãu");
    namesMap.put("BV", "Ilha Buve");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BZ", "Belizi");
    namesMap.put("CA", "Kanadá");
    namesMap.put("CC", "Ilhas Kokus");
    namesMap.put("CD", "Kongu - Kinxasa");
    namesMap.put("CF", "Republika Sentru-Afrikanu");
    namesMap.put("CG", "Kongu - Brazavili");
    namesMap.put("CH", "Suisa");
    namesMap.put("CI", "Kosta di Marfin");
    namesMap.put("CK", "Ilhas Kuk");
    namesMap.put("CL", "Xili");
    namesMap.put("CM", "Kamarõis");
    namesMap.put("CN", "Xina");
    namesMap.put("CO", "Kulombia");
    namesMap.put("CP", "Ilha Kliperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kabu Verdi");
    namesMap.put("CW", "Kurasau");
    namesMap.put("CX", "Ilha di Natal");
    namesMap.put("CY", "Xipri");
    namesMap.put("CZ", "Republika Txeka");
    namesMap.put("DE", "Alimanha");
    namesMap.put("DG", "Diegu Garsia");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Repúblika Dominikana");
    namesMap.put("DZ", "Arjelia");
    namesMap.put("EA", "Seuta i Melila");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EE", "Stonia");
    namesMap.put("EG", "Ejitu");
    namesMap.put("EH", "Sara Osidental");
    namesMap.put("ER", "Iritreia");
    namesMap.put("ES", "Spanha");
    namesMap.put("ET", "Itiopia");
    namesMap.put("EU", "Uniãu Europeia");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Ilhas Malvinas");
    namesMap.put("FM", "Mikronezia");
    namesMap.put("FO", "Ilhas Faroe");
    namesMap.put("FR", "Fransa");
    namesMap.put("GA", "Gabãu");
    namesMap.put("GB", "Reinu Unidu");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Jiorjia");
    namesMap.put("GF", "Giana Franseza");
    namesMap.put("GG", "Gernzi");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Jibraltar");
    namesMap.put("GL", "Gronelandia");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Guadalupi");
    namesMap.put("GQ", "Gine Ekuatorial");
    namesMap.put("GR", "Gresia");
    namesMap.put("GS", "Jeórjia di Sul i Ilhas di Sanduixi di Sul");
    namesMap.put("GT", "Guatimala");
    namesMap.put("GW", "Gine-Bisau");
    namesMap.put("GY", "Giana");
    namesMap.put("HK", "Rejiãu Administrativu Special di Ong Kong");
    namesMap.put("HM", "Ilha Heard i Ilhas McDonald");
    namesMap.put("HN", "Onduras");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HT", "Aiti");
    namesMap.put("HU", "Ungria");
    namesMap.put("IC", "Kanárias");
    namesMap.put("ID", "Indonezia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Ilha di Man");
    namesMap.put("IO", "Ilhas Britanika di Indiku");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Iron");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JE", "Jersi");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japãu");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgiston");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Kamoris");
    namesMap.put("KN", "Sãu Kristovãu i Nevis");
    namesMap.put("KP", "Koreia di Norti");
    namesMap.put("KR", "Koreia di Sul");
    namesMap.put("KW", "Kueiti");
    namesMap.put("KY", "Ilhas Kaimãu");
    namesMap.put("KZ", "Kazakistãu");
    namesMap.put("LA", "Laus");
    namesMap.put("LB", "Libanu");
    namesMap.put("LC", "Santa Lúsia");
    namesMap.put("LI", "Lixenstain");
    namesMap.put("LS", "Lezotu");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgu");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marokus");
    namesMap.put("MC", "Monaku");
    namesMap.put("MD", "Moldavia");
    namesMap.put("ME", "Montenegru");
    namesMap.put("MF", "Sãu Martinhu di Fransa");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Ilhas Marxal");
    namesMap.put("MK", "Masidonia");
    namesMap.put("MM", "Mianmar");
    namesMap.put("MO", "Rejiãu Administrativu Special di Makau");
    namesMap.put("MP", "Ilhas Marianas di Norti");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MS", "Monserat");
    namesMap.put("MU", "Ilhas Maurisia");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "Mexiku");
    namesMap.put("MY", "Malazia");
    namesMap.put("MZ", "Musambiki");
    namesMap.put("NC", "Nova Kalidonia");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Ilhas Norfolk");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Olanda");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zilandia");
    namesMap.put("PF", "Polinezia Franseza");
    namesMap.put("PG", "Papua-Nova Gine");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Pakistãu");
    namesMap.put("PL", "Pulonia");
    namesMap.put("PM", "San Piere i Mikelon");
    namesMap.put("PN", "Pirkairn");
    namesMap.put("PR", "Portu Riku");
    namesMap.put("PS", "Palistina");
    namesMap.put("PT", "Purtugal");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Oseania Insular");
    namesMap.put("RE", "Runion");
    namesMap.put("RO", "Romenia");
    namesMap.put("RS", "Servia");
    namesMap.put("RU", "Rúsia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Ilhas Salumon");
    namesMap.put("SC", "Seixelis");
    namesMap.put("SD", "Sudãu");
    namesMap.put("SE", "Suesia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SH", "Santa Ilena");
    namesMap.put("SJ", "Svalbard i Jan Maien");
    namesMap.put("SL", "Sera Lioa");
    namesMap.put("SM", "San Marinu");
    namesMap.put("SO", "Sumalia");
    namesMap.put("SR", "Surinami");
    namesMap.put("SS", "Sudãu di Sul");
    namesMap.put("ST", "Sãu Tume i Prinsipi");
    namesMap.put("SX", "Sãu Martinhu di Olanda");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suazilándia");
    namesMap.put("TA", "Tristan da Kunha");
    namesMap.put("TC", "Ilhas Turkas i Kaikus");
    namesMap.put("TD", "Txadi");
    namesMap.put("TF", "Terras Franses di Sul");
    namesMap.put("TG", "Togu");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Tadjikistãu");
    namesMap.put("TL", "Timor Lesti");
    namesMap.put("TM", "Turkumenistãu");
    namesMap.put("TN", "Tunizia");
    namesMap.put("TR", "Turkia");
    namesMap.put("TT", "Trinidad i Tobagu");
    namesMap.put("TW", "Taiuan");
    namesMap.put("UA", "Ukrania");
    namesMap.put("UM", "Ilhas Minoris Distantis de Stadus Unidus");
    namesMap.put("US", "Stadus Unidos di Merka");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbekistãu");
    namesMap.put("VA", "Vatikanu");
    namesMap.put("VC", "Sãu Bisenti i Granadinas");
    namesMap.put("VE", "Vinizuea");
    namesMap.put("VG", "Ilhas Virjens Britanikas");
    namesMap.put("VI", "Ilhas Virjens Merkanu");
    namesMap.put("WF", "Ualis i Futuna");
    namesMap.put("YE", "Iemen");
    namesMap.put("YT", "Maiote");
    namesMap.put("ZA", "Afrika di Sul");
    namesMap.put("ZW", "Zimbabui");
    namesMap.put("ZZ", "Rejiãu Diskonxedu");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundu",
        "002": "Afrika",
        "003": "Merka di Norti",
        "005": "Merka di Sul",
        "009": "Oseania",
        "011": "Afrika Osidental",
        "013": "Merka Sentral",
        "014": "Afrika Oriental",
        "015": "Norti di Afrika",
        "017": "Afrika Sentral",
        "018": "Sul di Afrika",
        "019": "Merkas",
        "021": "Norti di Merka",
        "029": "Karaibas",
        "030": "Azia Oriental",
        "034": "Sul di Azia",
        "035": "Sudesti Aziatiku",
        "039": "Europa di Sul",
        "053": "Australazia",
        "054": "Melanezia",
        "057": "Rejiãu di Mikronezia",
        "061": "Polinezia",
        "142": "Azia",
        "143": "Azia Sentral",
        "145": "Azia Osidental",
        "150": "Europa",
        "151": "Europa Oriental",
        "154": "Europa di Norti",
        "155": "Europa Osidental",
        "419": "Merka Latinu",
        "AC": "Ilha di Asensãu",
        "AD": "Andora",
        "AE": "Emiradus Arabi Unidu",
        "AF": "Afeganistãu",
        "AG": "Antigua i Barbuda",
        "AI": "Angila",
        "AN": "Antilhas Olandeza",
        "AQ": "Antartika",
        "AR": "Arjentina",
        "AS": "Samoa Merkanu",
        "AX": "Ilhas Åland",
        "AZ": "Azerbaijãu",
        "BA": "Bosnia-Erzegovina",
        "BB": "Barbadus",
        "BD": "Bangladexi",
        "BE": "Béljika",
        "BF": "Burkina Fasu",
        "BH": "Barain",
        "BL": "Sãu Bartolomeu",
        "BM": "Bermudas",
        "BQ": "Karaibas olandes",
        "BS": "Baamas",
        "BT": "Butãu",
        "BV": "Ilha Buve",
        "BW": "Botsuana",
        "BZ": "Belizi",
        "CA": "Kanadá",
        "CC": "Ilhas Kokus",
        "CD": "Kongu - Kinxasa",
        "CF": "Republika Sentru-Afrikanu",
        "CG": "Kongu - Brazavili",
        "CH": "Suisa",
        "CI": "Kosta di Marfin",
        "CK": "Ilhas Kuk",
        "CL": "Xili",
        "CM": "Kamarõis",
        "CN": "Xina",
        "CO": "Kulombia",
        "CP": "Ilha Kliperton",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Kabu Verdi",
        "CW": "Kurasau",
        "CX": "Ilha di Natal",
        "CY": "Xipri",
        "CZ": "Republika Txeka",
        "DE": "Alimanha",
        "DG": "Diegu Garsia",
        "DJ": "Djibuti",
        "DK": "Dinamarka",
        "DM": "Dominika",
        "DO": "Repúblika Dominikana",
        "DZ": "Arjelia",
        "EA": "Seuta i Melila",
        "EC": "Ekuador",
        "EE": "Stonia",
        "EG": "Ejitu",
        "EH": "Sara Osidental",
        "ER": "Iritreia",
        "ES": "Spanha",
        "ET": "Itiopia",
        "EU": "Uniãu Europeia",
        "FI": "Finlandia",
        "FJ": "Fidji",
        "FK": "Ilhas Malvinas",
        "FM": "Mikronezia",
        "FO": "Ilhas Faroe",
        "FR": "Fransa",
        "GA": "Gabãu",
        "GB": "Reinu Unidu",
        "GD": "Granada",
        "GE": "Jiorjia",
        "GF": "Giana Franseza",
        "GG": "Gernzi",
        "GH": "Gana",
        "GI": "Jibraltar",
        "GL": "Gronelandia",
        "GN": "Gine",
        "GP": "Guadalupi",
        "GQ": "Gine Ekuatorial",
        "GR": "Gresia",
        "GS": "Jeórjia di Sul i Ilhas di Sanduixi di Sul",
        "GT": "Guatimala",
        "GW": "Gine-Bisau",
        "GY": "Giana",
        "HK": "Rejiãu Administrativu Special di Ong Kong",
        "HM": "Ilha Heard i Ilhas McDonald",
        "HN": "Onduras",
        "HR": "Kroasia",
        "HT": "Aiti",
        "HU": "Ungria",
        "IC": "Kanárias",
        "ID": "Indonezia",
        "IE": "Irlanda",
        "IM": "Ilha di Man",
        "IO": "Ilhas Britanika di Indiku",
        "IQ": "Iraki",
        "IR": "Iron",
        "IS": "Islandia",
        "IT": "Italia",
        "JE": "Jersi",
        "JM": "Jamaika",
        "JO": "Jordania",
        "JP": "Japãu",
        "KE": "Kenia",
        "KG": "Kirgiston",
        "KH": "Kambodja",
        "KM": "Kamoris",
        "KN": "Sãu Kristovãu i Nevis",
        "KP": "Koreia di Norti",
        "KR": "Koreia di Sul",
        "KW": "Kueiti",
        "KY": "Ilhas Kaimãu",
        "KZ": "Kazakistãu",
        "LA": "Laus",
        "LB": "Libanu",
        "LC": "Santa Lúsia",
        "LI": "Lixenstain",
        "LS": "Lezotu",
        "LT": "Lituania",
        "LU": "Luxemburgu",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Marokus",
        "MC": "Monaku",
        "MD": "Moldavia",
        "ME": "Montenegru",
        "MF": "Sãu Martinhu di Fransa",
        "MG": "Madagaskar",
        "MH": "Ilhas Marxal",
        "MK": "Masidonia",
        "MM": "Mianmar",
        "MO": "Rejiãu Administrativu Special di Makau",
        "MP": "Ilhas Marianas di Norti",
        "MQ": "Martinika",
        "MS": "Monserat",
        "MU": "Ilhas Maurisia",
        "MV": "Maldivas",
        "MW": "Malaui",
        "MX": "Mexiku",
        "MY": "Malazia",
        "MZ": "Musambiki",
        "NC": "Nova Kalidonia",
        "NE": "Nijer",
        "NF": "Ilhas Norfolk",
        "NG": "Nijeria",
        "NI": "Nikaragua",
        "NL": "Olanda",
        "NO": "Noruega",
        "NZ": "Nova Zilandia",
        "PF": "Polinezia Franseza",
        "PG": "Papua-Nova Gine",
        "PH": "Filipinas",
        "PK": "Pakistãu",
        "PL": "Pulonia",
        "PM": "San Piere i Mikelon",
        "PN": "Pirkairn",
        "PR": "Portu Riku",
        "PS": "Palistina",
        "PT": "Purtugal",
        "PY": "Paraguai",
        "QA": "Katar",
        "QO": "Oseania Insular",
        "RE": "Runion",
        "RO": "Romenia",
        "RS": "Servia",
        "RU": "Rúsia",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Ilhas Salumon",
        "SC": "Seixelis",
        "SD": "Sudãu",
        "SE": "Suesia",
        "SG": "Singapura",
        "SH": "Santa Ilena",
        "SJ": "Svalbard i Jan Maien",
        "SL": "Sera Lioa",
        "SM": "San Marinu",
        "SO": "Sumalia",
        "SR": "Surinami",
        "SS": "Sudãu di Sul",
        "ST": "Sãu Tume i Prinsipi",
        "SX": "Sãu Martinhu di Olanda",
        "SY": "Siria",
        "SZ": "Suazilándia",
        "TA": "Tristan da Kunha",
        "TC": "Ilhas Turkas i Kaikus",
        "TD": "Txadi",
        "TF": "Terras Franses di Sul",
        "TG": "Togu",
        "TH": "Tailandia",
        "TJ": "Tadjikistãu",
        "TL": "Timor Lesti",
        "TM": "Turkumenistãu",
        "TN": "Tunizia",
        "TR": "Turkia",
        "TT": "Trinidad i Tobagu",
        "TW": "Taiuan",
        "UA": "Ukrania",
        "UM": "Ilhas Minoris Distantis de Stadus Unidus",
        "US": "Stadus Unidos di Merka",
        "UY": "Uruguai",
        "UZ": "Uzbekistãu",
        "VA": "Vatikanu",
        "VC": "Sãu Bisenti i Granadinas",
        "VE": "Vinizuea",
        "VG": "Ilhas Virjens Britanikas",
        "VI": "Ilhas Virjens Merkanu",
        "WF": "Ualis i Futuna",
        "YE": "Iemen",
        "YT": "Maiote",
        "ZA": "Afrika di Sul",
        "ZW": "Zimbabui",
        "ZZ": "Rejiãu Diskonxedu"
    };
  }-*/;
}
