/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.light.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.jaxws.light.JAXWSLightSupportAccessor;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.openide.filesystems.FileObject;

public final class JAXWSLightSupport {
    public static final String PROPERTY_SERVICE_ADDED = "service-added";
    public static final String PROPERTY_SERVICE_REMOVED = "service-removed";
    private JAXWSLightSupportImpl impl;
    private PropertyChangeSupport propertyChangeSupport;
    private ReentrantReadWriteLock myLock;
    private ReentrantReadWriteLock.ReadLock myReadLock;
    private ReentrantReadWriteLock.WriteLock myWriteLoick;

    private JAXWSLightSupport(JAXWSLightSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.myLock = new ReentrantReadWriteLock();
        this.myReadLock = this.myLock.readLock();
        this.myWriteLoick = this.myLock.writeLock();
    }

    public static JAXWSLightSupport getJAXWSLightSupport(FileObject f) {
        JAXWSLightSupportProvider provider;
        Project project = FileOwnerQuery.getOwner((FileObject)f);
        if (project != null && (provider = (JAXWSLightSupportProvider)project.getLookup().lookup(JAXWSLightSupportProvider.class)) != null) {
            return provider.findJAXWSSupport();
        }
        return null;
    }

    public void addService(JaxWsService service) {
        this.checkLock();
        this.impl.addService(service);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVICE_ADDED, null, service);
    }

    public List<JaxWsService> getServices() {
        this.myReadLock.lock();
        try {
            List<JaxWsService> list = this.impl.getServices();
            return list;
        }
        finally {
            this.myReadLock.unlock();
        }
    }

    public void removeService(JaxWsService service) {
        this.checkLock();
        this.impl.removeService(service);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVICE_REMOVED, service, null);
    }

    public void runAtomic(Runnable runnable) {
        this.myWriteLoick.lock();
        try {
            runnable.run();
        }
        finally {
            this.myWriteLoick.unlock();
        }
    }

    public FileObject getDeploymentDescriptorFolder() {
        return this.impl.getDeploymentDescriptorFolder();
    }

    public FileObject getWsdlFolder(boolean createFolder) {
        return this.impl.getWsdlFolder(createFolder);
    }

    public FileObject getBindingsFolder(boolean createFolder) {
        return this.impl.getBindingsFolder(createFolder);
    }

    public URL getCatalog() {
        return this.impl.getCatalog();
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return this.impl.getWebservicesMetadataModel();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    private void checkLock() {
        if (!this.myWriteLoick.isHeldByCurrentThread()) {
            throw new IllegalStateException("Trying to invoke mutable operation outside of transaction. Atomic access should be used for mutable opertations");
        }
    }

    static {
        JAXWSLightSupportAccessor.DEFAULT = new JAXWSLightSupportAccessor(){

            @Override
            public JAXWSLightSupport createJAXWSSupport(JAXWSLightSupportImpl spiWebServicesSupport) {
                return new JAXWSLightSupport(spiWebServicesSupport);
            }

            @Override
            public JAXWSLightSupportImpl getJAXWSSupportImpl(JAXWSLightSupport wss) {
                return wss == null ? null : wss.impl;
            }
        };
    }
}

