/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteBackupRequest
extends BmcRequest<Void> {
    private String backupId;
    private String ifMatch;

    @ConstructorProperties(value={"backupId", "ifMatch"})
    DeleteBackupRequest(String backupId, String ifMatch) {
        this.backupId = backupId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().backupId(this.backupId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteBackupRequest(super=" + super.toString() + ", backupId=" + this.getBackupId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteBackupRequest)) {
            return false;
        }
        DeleteBackupRequest other = (DeleteBackupRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$backupId = this.getBackupId();
        String other$backupId = other.getBackupId();
        if (this$backupId == null ? other$backupId != null : !this$backupId.equals(other$backupId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteBackupRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $backupId = this.getBackupId();
        result = result * 59 + ($backupId == null ? 43 : $backupId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteBackupRequest, Void> {
        private String backupId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBackupRequest o) {
            this.backupId(o.getBackupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBackupRequest build() {
            DeleteBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteBackupRequest buildWithoutInvocationCallback() {
            return new DeleteBackupRequest(this.backupId, this.ifMatch);
        }

        public String toString() {
            return "DeleteBackupRequest.Builder(backupId=" + this.backupId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

