/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseDataguardAssociation;
import com.oracle.bmc.database.requests.SwitchoverAutonomousContainerDatabaseDataguardAssociationRequest;
import com.oracle.bmc.database.responses.SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchoverAutonomousContainerDatabaseDataguardAssociationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchoverAutonomousContainerDatabaseDataguardAssociationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static SwitchoverAutonomousContainerDatabaseDataguardAssociationRequest interceptRequest(SwitchoverAutonomousContainerDatabaseDataguardAssociationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, SwitchoverAutonomousContainerDatabaseDataguardAssociationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousContainerDatabaseId(), (String)"autonomousContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousContainerDatabaseDataguardAssociationId(), (String)"autonomousContainerDatabaseDataguardAssociationId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousContainerDatabases").path(HttpUtils.encodePathSegment((String)request.getAutonomousContainerDatabaseId())).path("autonomousContainerDatabaseDataguardAssociations").path(HttpUtils.encodePathSegment((String)request.getAutonomousContainerDatabaseDataguardAssociationId())).path("actions").path("switchover");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse> fromResponse() {
        Function<Response, SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse> transformer = new Function<Response, SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse>(){

            public SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousContainerDatabaseDataguardAssociation.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse.Builder builder = SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.autonomousContainerDatabaseDataguardAssociation((AutonomousContainerDatabaseDataguardAssociation)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                SwitchoverAutonomousContainerDatabaseDataguardAssociationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

