/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.Patch;
import com.oracle.bmc.database.requests.GetVmClusterPatchRequest;
import com.oracle.bmc.database.responses.GetVmClusterPatchResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVmClusterPatchConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetVmClusterPatchConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetVmClusterPatchRequest interceptRequest(GetVmClusterPatchRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetVmClusterPatchRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVmClusterId(), (String)"vmClusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("vmClusters").path(HttpUtils.encodePathSegment((String)request.getVmClusterId())).path("patches").path(HttpUtils.encodePathSegment((String)request.getPatchId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetVmClusterPatchResponse> fromResponse() {
        Function<Response, GetVmClusterPatchResponse> transformer = new Function<Response, GetVmClusterPatchResponse>(){

            public GetVmClusterPatchResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetVmClusterPatchResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Patch.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetVmClusterPatchResponse.Builder builder = GetVmClusterPatchResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.patch((Patch)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetVmClusterPatchResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

