/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.Objects;
import java.util.stream.Stream;

public interface PoolConstant {
    default public Object poolKey(Types types) {
        return this;
    }

    public int poolTag();

    public static final class NameAndType
    implements PoolConstant {
        final Name name;
        final Type type;

        NameAndType(Name name, Type type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public int poolTag() {
            return 12;
        }

        @Override
        public Object poolKey(Types types) {
            return new Pair<Name, Types.UniqueType>(this.name, new Types.UniqueType(this.type, types));
        }
    }

    public static interface Dynamic
    extends PoolConstant {
        public PoolConstant dynamicType();

        public LoadableConstant[] staticArgs();

        public LoadableConstant bootstrapMethod();

        default public BsmKey bsmKey(Types types) {
            return new BsmKey(types, this.bootstrapMethod(), this.staticArgs());
        }

        @Override
        default public Object poolKey(Types types) {
            return new Pair<BsmKey, Object>(this.bsmKey(types), this.dynamicType().poolKey(types));
        }

        public static class BsmKey {
            public final LoadableConstant bsm;
            public final LoadableConstant[] staticArgs;
            private final Object bsmKey;
            private final List<?> staticArgKeys;

            private BsmKey(Types types, LoadableConstant bsm, LoadableConstant[] staticArgs) {
                this.bsm = bsm;
                this.bsmKey = bsm.poolKey(types);
                this.staticArgs = staticArgs;
                this.staticArgKeys = Stream.of(staticArgs).map(p -> p.poolKey(types)).collect(List.collector());
            }

            public int hashCode() {
                return this.bsmKey.hashCode() + this.staticArgKeys.hashCode();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                Object object = obj;
                if (!(object instanceof BsmKey)) return false;
                BsmKey key = (BsmKey)object;
                if (!Objects.equals(this.bsmKey, key.bsmKey)) return false;
                if (!Objects.equals(this.staticArgKeys, key.staticArgKeys)) return false;
                return true;
            }
        }
    }

    public static interface LoadableConstant
    extends PoolConstant {
        public static LoadableConstant Int(int i) {
            return new BasicConstant(3, i);
        }

        public static LoadableConstant Float(float f) {
            return new BasicConstant(4, Float.valueOf(f));
        }

        public static LoadableConstant Long(long l) {
            return new BasicConstant(5, l);
        }

        public static LoadableConstant Double(double d) {
            return new BasicConstant(6, d);
        }

        public static LoadableConstant String(String s) {
            return new BasicConstant(8, s);
        }

        public static class BasicConstant
        implements LoadableConstant {
            int tag;
            Object data;

            private BasicConstant(int tag, Object data) {
                this.tag = tag;
                this.data = data;
            }

            @Override
            public int poolTag() {
                return this.tag;
            }

            @Override
            public Object poolKey(Types types) {
                return this.data;
            }
        }
    }
}

