/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

class MessageFactory {
    private static final String MOJARRA_RESOURCE_BASENAME = "com.sun.faces.resources.Messages";

    private MessageFactory() {
    }

    static FacesMessage getMessage(String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage message = MessageFactory.getMessage(messageId, params);
        message.setSeverity(severity);
        return message;
    }

    static FacesMessage getMessage(Locale locale, String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage message = MessageFactory.getMessage(locale, messageId, params);
        message.setSeverity(severity);
        return message;
    }

    static FacesMessage getMessage(FacesContext context, String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage message = MessageFactory.getMessage(context, messageId, params);
        message.setSeverity(severity);
        return message;
    }

    static FacesMessage getMessage(String messageId, Object ... params) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageFactory.getMessage(locale, messageId, params);
    }

    static FacesMessage getMessage(Locale locale, String messageId, Object ... params) {
        ResourceBundle bundle;
        String summary = null;
        String detail = null;
        Application app = MessageFactory.getApplication();
        Class<?> appClass = app.getClass();
        String bundleName = app.getMessageBundle();
        if (null != bundleName && null != (bundle = ResourceBundle.getBundle(bundleName, locale, MessageFactory.getCurrentLoader(appClass)))) {
            try {
                summary = bundle.getString(messageId);
                detail = bundle.getString(messageId + "_detail");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (null == summary) {
            bundle = ResourceBundle.getBundle("javax.faces.Messages", locale, MessageFactory.getCurrentLoader(appClass));
            if (null == bundle) {
                throw new NullPointerException();
            }
            try {
                summary = bundle.getString(messageId);
                detail = bundle.getString(messageId + "_detail");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            bundle = ResourceBundle.getBundle(MOJARRA_RESOURCE_BASENAME, locale, MessageFactory.getCurrentLoader(appClass));
            if (null == bundle) {
                throw new NullPointerException();
            }
            try {
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        BindingFacesMessage ret = new BindingFacesMessage(locale, summary, detail, params);
        ret.setSeverity(FacesMessage.SEVERITY_ERROR);
        return ret;
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object ... params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + context + " messageId " + messageId);
        }
        Locale locale = context.getViewRoot() != null ? context.getViewRoot().getLocale() : Locale.getDefault();
        if (null == locale) {
            throw new NullPointerException(" locale is null ");
        }
        FacesMessage message = MessageFactory.getMessage(locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageFactory.getMessage(locale, messageId, params);
    }

    static Object getLabel(FacesContext context, UIComponent component) {
        Object o = component.getAttributes().get("label");
        if (o == null || o instanceof String && ((String)o).length() == 0) {
            o = component.getValueExpression("label");
        }
        if (o == null) {
            o = component.getClientId(context);
        }
        return o;
    }

    protected static Application getApplication() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return FacesContext.getCurrentInstance().getApplication();
        }
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }

    protected static ClassLoader getCurrentLoader(Class fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClassLoader();
        }
        return loader;
    }

    static class BindingFacesMessage
    extends FacesMessage {
        private Locale locale;
        private Object[] parameters;
        private Object[] resolvedParameters;

        BindingFacesMessage(Locale locale, String messageFormat, String detailMessageFormat, Object[] parameters) {
            super(messageFormat, detailMessageFormat);
            this.locale = locale;
            this.parameters = parameters;
            if (parameters != null) {
                this.resolvedParameters = new Object[parameters.length];
            }
        }

        @Override
        public String getSummary() {
            String pattern = super.getSummary();
            this.resolveBindings();
            return this.getFormattedString(pattern, this.resolvedParameters);
        }

        @Override
        public String getDetail() {
            String pattern = super.getDetail();
            this.resolveBindings();
            return this.getFormattedString(pattern, this.resolvedParameters);
        }

        private void resolveBindings() {
            FacesContext context = null;
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    Object o = this.parameters[i];
                    if (o instanceof ValueBinding) {
                        if (context == null) {
                            context = FacesContext.getCurrentInstance();
                        }
                        o = ((ValueBinding)o).getValue(context);
                    }
                    if (o instanceof ValueExpression) {
                        if (context == null) {
                            context = FacesContext.getCurrentInstance();
                        }
                        o = ((ValueExpression)o).getValue(context.getELContext());
                    }
                    if (o == null) {
                        o = "";
                    }
                    this.resolvedParameters[i] = o;
                }
            }
        }

        private String getFormattedString(String msgtext, Object[] params) {
            String localizedStr = null;
            if (params == null || msgtext == null) {
                return msgtext;
            }
            StringBuffer b = new StringBuffer(100);
            MessageFormat mf = new MessageFormat(msgtext);
            if (this.locale != null) {
                mf.setLocale(this.locale);
                b.append(mf.format(params));
                localizedStr = b.toString();
            }
            return localizedStr;
        }
    }
}

