/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.JsfPreferences;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesValidator;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.api.facesmodel.ResourceBundle;
import org.netbeans.modules.web.jsf.api.metamodel.ClientBehaviorRenderer;
import org.netbeans.modules.web.jsf.api.metamodel.Component;
import org.netbeans.modules.web.jsf.api.metamodel.FacesConverter;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.Renderer;
import org.netbeans.modules.web.jsf.api.metamodel.Validator;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class JSFConfigUtilities {
    private static final Logger LOGGER = Logger.getLogger(JSFConfigUtilities.class.getName());
    private static String CONFIG_FILES_PARAM_NAME = "javax.faces.CONFIG_FILES";
    private static String FACES_PARAM = "javax.faces";
    private static String DEFAULT_FACES_CONFIG_PATH = "WEB-INF/faces-config.xml";
    private static final Class[] types = new Class[]{FacesManagedBean.class, Component.class, FacesValidator.class, FacesConverter.class, ClientBehaviorRenderer.class, ResourceBundle.class, Validator.class, Converter.class, Renderer.class};
    private static final Set<String> JSF_RESOURCES = new HashSet<String>(Arrays.asList("javax.faces.bean.ManagedBean", "javax.faces.component.behavior.FacesBehavior", "javax.faces.convert.FacesConverter", "javax.faces.component.FacesComponent", "javax.faces.validator.FacesValidator", "javax.faces.render.FacesBehaviorRenderer", "javax.faces.render.FacesRenderer", "javax.faces.event.ListenerFor"));
    private static List<ElementHandle> jsfResourcesElementHandles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasJsfFramework(FileObject fileObject) {
        if (fileObject != null) {
            Project project;
            JsfPreferences projectPreferences;
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            if (webModule == null) {
                return false;
            }
            String[] configFiles = JSFConfigUtilities.getConfigFiles(webModule);
            if (configFiles != null && configFiles.length > 0) {
                return true;
            }
            FileObject dd = webModule.getDeploymentDescriptor();
            if (dd != null) {
                if (ConfigurationUtils.getFacesServlet(webModule) != null) {
                    return true;
                }
                try {
                    WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
                    if (ddRoot != null) {
                        InitParam[] parameters;
                        for (InitParam param : parameters = ddRoot.getContextParam()) {
                            String paramName = param.getParamName();
                            if (paramName == null || !paramName.startsWith(FACES_PARAM)) continue;
                            return true;
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage());
                }
            }
            if (!(projectPreferences = JsfPreferences.forProject(project = FileOwnerQuery.getOwner((FileObject)fileObject))).isJsfPresent()) {
                long time = System.currentTimeMillis();
                try {
                    MetadataModel<JsfModel> model = JSFUtils.getModel(project);
                    if (model == null) {
                        boolean param = false;
                        return param;
                    }
                    Future future = model.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<JsfModel, Boolean>(){

                        public Boolean run(JsfModel metadata) throws Exception {
                            for (Class clazz : types) {
                                if (metadata.getElements(clazz).isEmpty()) continue;
                                return Boolean.TRUE;
                            }
                            return Boolean.FALSE;
                        }
                    });
                    if (future.isDone() && ((Boolean)future.get()).booleanValue() && JSFConfigUtilities.jsfArtifactsInSourceRoot(webModule)) {
                        projectPreferences.setJsfPresent(true);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (NullPointerException model) {
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage());
                }
                finally {
                    LOGGER.log(Level.INFO, "Total time spent = {0} ms", System.currentTimeMillis() - time);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static boolean jsfArtifactsInSourceRoot(WebModule webModule) throws IOException {
        FileObject[] facesConfigFiles = ConfigurationUtils.getFacesConfigFiles(webModule);
        if (facesConfigFiles.length > 0) {
            return true;
        }
        final AtomicBoolean resourceFound = new AtomicBoolean(false);
        JavaSource js = JSFConfigUtilities.createJavaSource(webModule);
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                resourceFound.set(JSFConfigUtilities.containsAnnotatedJsfResource(parameter));
            }
        }, true);
        return resourceFound.get();
    }

    public static JavaSource createJavaSource(WebModule webModule) {
        Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        ClassPath bootCP = cpp.findClassPath(webModule.getDocumentBase(), "classpath/boot");
        ClassPath compileCP = cpp.findClassPath(webModule.getDocumentBase(), "classpath/compile");
        ClassPath sourceCP = cpp.findClassPath(webModule.getDocumentBase(), "classpath/source");
        return JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)bootCP, (ClassPath)compileCP, (ClassPath)sourceCP), Collections.emptyList());
    }

    private static boolean containsAnnotatedJsfResource(CompilationController parameter) {
        if (jsfResourcesElementHandles == null) {
            JSFConfigUtilities.loadJsfResourcesElementsHandles(parameter);
        }
        ClassIndex classIndex = parameter.getClasspathInfo().getClassIndex();
        for (ElementHandle jsfResourceElementHandle : jsfResourcesElementHandles) {
            Set elements = classIndex.getElements(jsfResourceElementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle handle : elements) {
                TypeElement element = (TypeElement)handle.resolve((CompilationInfo)parameter);
                if (element == null) continue;
                List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : annotationMirrors) {
                    if (!ElementHandle.create((Element)annotationMirror.getAnnotationType().asElement()).equals((Object)jsfResourceElementHandle)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void loadJsfResourcesElementsHandles(CompilationController parameter) {
        jsfResourcesElementHandles = new ArrayList<ElementHandle>(JSF_RESOURCES.size());
        for (String canonicalName : JSF_RESOURCES) {
            TypeElement typeElement = parameter.getElements().getTypeElement(canonicalName);
            if (typeElement == null) continue;
            jsfResourcesElementHandles.add(ElementHandle.create((Element)typeElement));
        }
    }

    public static Set extendJsfFramework(FileObject fileObject, boolean createWelcomeFile) {
        Set result = Collections.emptySet();
        if (fileObject == null) {
            return result;
        }
        List frameworks = WebFrameworks.getFrameworks();
        for (WebFrameworkProvider framework : frameworks) {
            if (!(framework instanceof JSFFrameworkProvider)) continue;
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            if (webModule.getDocumentBase() != null) {
                ((JSFFrameworkProvider)framework).setCreateWelcome(createWelcomeFile);
                WebModuleExtender extender = framework.createWebModuleExtender(webModule, ExtenderController.create());
                result = extender.extend(webModule);
            }
            return result;
        }
        return result;
    }

    public static NavigationRule findNavigationRule(JSFConfigDataObject data, String fromView) {
        NavigationRule navigationRule = null;
        FacesConfig config = ConfigurationUtils.getConfigModel(data.getPrimaryFile(), true).getRootComponent();
        List<NavigationRule> rules = config.getNavigationRules();
        for (NavigationRule nRule : rules) {
            if ((fromView == null || !fromView.equals(nRule.getFromViewId())) && (fromView != null || nRule.getFromViewId() != null && nRule.getFromViewId().trim().length() != 0)) continue;
            navigationRule = nRule;
        }
        return navigationRule;
    }

    public static SourceGroup[] getDocBaseGroups(FileObject fileObject) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        return sources.getSourceGroups("doc_root");
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fileObject, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fileObject)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fileObject);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }

    public static boolean validateXML(FileObject deploymentDesc) {
        boolean value = false;
        if (deploymentDesc != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(deploymentDesc);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.validateXml");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return value;
    }

    public static boolean verifyObjects(FileObject deploymentDesc) {
        boolean value = false;
        if (deploymentDesc != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(deploymentDesc);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.verifyObjects");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return value;
    }

    public static String[] getConfigFiles(WebModule webModule) {
        if (webModule == null) {
            return new String[0];
        }
        return JSFConfigUtilities.getConfigFiles(webModule, webModule.getDeploymentDescriptor());
    }

    public static String[] getConfigFiles(WebModule webModule, FileObject deploymentDesc) {
        FileObject baseDir;
        HashSet<String> files = new HashSet<String>();
        if (webModule != null && (baseDir = webModule.getDocumentBase()) != null) {
            FileObject fileObject = baseDir.getFileObject(DEFAULT_FACES_CONFIG_PATH);
            if (fileObject != null) {
                files.add(DEFAULT_FACES_CONFIG_PATH);
            }
            if (deploymentDesc != null) {
                String value;
                int i;
                InitParam param;
                block9: {
                    param = null;
                    try {
                        WebApp webApp = DDProvider.getDefault().getDDRoot(deploymentDesc);
                        if (webApp == null) break block9;
                        InitParam[] params = webApp.getContextParam();
                        for (i = 0; i < params.length; ++i) {
                            InitParam initParam = params[i];
                            if (initParam.getParamName() == null || !CONFIG_FILES_PARAM_NAME.equals(initParam.getParamName().trim())) continue;
                            param = initParam;
                            break;
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                if (param != null && (value = param.getParamValue().trim()) != null) {
                    String[] filesURI = value.split(",");
                    for (i = 0; i < filesURI.length; ++i) {
                        FileObject config;
                        String filePath = filesURI[i].trim();
                        if (filePath.startsWith("/")) {
                            filePath = filePath.substring(1);
                        }
                        if ((config = baseDir.getFileObject(filePath)) == null || config.isFolder()) continue;
                        files.add(filePath);
                    }
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }
}

