/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAMap;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;

public class PureNFAMarkLookBehindEntries {
    private final PureNFAMap nfa;
    private StateSet<PureNFA, PureNFAState> markLiteralStatesCur;
    private StateSet<PureNFA, PureNFAState> markLiteralStatesNext;

    public PureNFAMarkLookBehindEntries(PureNFAMap nfa) {
        this.nfa = nfa;
        this.markLiteralStatesCur = StateSet.create(nfa.getRoot());
        this.markLiteralStatesNext = StateSet.create(nfa.getRoot());
    }

    public void markEntries() {
        if (!this.nfa.getAst().getProperties().hasLookBehindAssertions()) {
            return;
        }
        for (PureNFA subTree : this.nfa.getLookArounds()) {
            this.markEntriesInSubtree(subTree, false);
        }
        this.markEntriesInSubtree(this.nfa.getRoot(), true);
    }

    private void markEntriesInSubtree(PureNFA subtree, boolean subtreeIsRoot) {
        for (PureNFAState s : subtree.getStates()) {
            if (!s.isLookBehind(this.nfa.getAst())) continue;
            LookBehindAssertion lb = (LookBehindAssertion)s.getAstNode(this.nfa.getAst());
            PureNFA lookBehindNFA = (PureNFA)this.nfa.getLookArounds().get(lb.getSubTreeId());
            if (subtreeIsRoot && lb.getGroup().isLiteral()) {
                this.markLiteral(s, lookBehindNFA);
                continue;
            }
            this.markGeneric(s, lookBehindNFA);
        }
    }

    private void markLiteral(PureNFAState parentState, PureNFA lb) {
        PureNFAState lbChar = lb.getReverseUnAnchoredEntry().getSource();
        this.markLiteralStatesCur.clear();
        this.markLiteralStatesCur.add(parentState);
        while (!this.markLiteralStatesCur.isEmpty()) {
            this.markLiteralStatesNext.clear();
            assert (((PureNFATransition[])lbChar.getPredecessors()).length == 1);
            lbChar = ((PureNFATransition[])lbChar.getPredecessors())[0].getSource();
            assert (!lbChar.isInitialState() && !lbChar.isFinalState());
            block1: for (PureNFAState cur : this.markLiteralStatesCur) {
                if (cur.isAnchoredInitialState()) continue;
                if (cur.isUnAnchoredInitialState()) {
                    int offset = 0;
                    PureNFAState prevLBState = lbChar;
                    do {
                        assert (((PureNFATransition[])prevLBState.getPredecessors()).length == 1);
                        prevLBState = ((PureNFATransition[])prevLBState.getPredecessors())[0].getSource();
                        ++offset;
                    } while (!prevLBState.isUnAnchoredInitialState());
                    this.nfa.addPrefixLookBehindEntry(lb, offset);
                    continue;
                }
                if (!cur.getCharSet().intersects(lbChar.getCharSet())) continue;
                assert (((PureNFATransition[])lbChar.getPredecessors()).length == 1);
                PureNFAState prevLBState = ((PureNFATransition[])lbChar.getPredecessors())[0].getSource();
                if (prevLBState.isAnchoredInitialState()) {
                    for (PureNFATransition curTransition : (PureNFATransition[])cur.getPredecessors()) {
                        if (!curTransition.getSource().isInitialState()) continue;
                        this.addLookBehindEntry(cur, lb);
                        continue block1;
                    }
                    continue;
                }
                if (prevLBState.isUnAnchoredInitialState()) {
                    this.addLookBehindEntry(cur, lb);
                    continue;
                }
                for (PureNFATransition curTransition : (PureNFATransition[])cur.getPredecessors()) {
                    this.markLiteralStatesNext.add(curTransition.getSource());
                }
            }
            StateSet<PureNFA, PureNFAState> tmp = this.markLiteralStatesCur;
            this.markLiteralStatesCur = this.markLiteralStatesNext;
            this.markLiteralStatesNext = tmp;
        }
    }

    private void markGeneric(PureNFAState s, PureNFA lookBehindNFA) {
        throw new UnsupportedRegexException("not implemented", this.nfa.getAst().getSource());
    }

    private void addLookBehindEntry(PureNFAState state, PureNFA lookBehind) {
        throw new UnsupportedRegexException("not implemented", this.nfa.getAst().getSource());
    }
}

