/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.jshell.Snippet;
import org.netbeans.modules.jshell.support.ShellHistory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FileHistory
implements ShellHistory {
    private static final Logger LOG = Logger.getLogger(FileHistory.class.getName());
    private static final int MAX_HISTORY_ITEMS = 50;
    private FileObject historyFile;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private List<ShellHistory.Item> items;
    private boolean fileWarned;
    private int maxHistory = 50;
    private static final String MARKER = "#>";
    private static final String KIND_COMMAND = "CMD";

    protected FileHistory(FileObject historyFile) {
        this.historyFile = historyFile;
    }

    protected void setMaxHistoryItems(int max) {
        this.maxHistory = max;
    }

    @Override
    public List<ShellHistory.Item> getHistory() {
        this.load();
        return this.items;
    }

    private String item2String(ShellHistory.Item item) {
        String k = item.isShellCommand() ? KIND_COMMAND : item.getKind().name().toUpperCase();
        return k + MARKER + item.getContents();
    }

    private ShellHistory.Item string2Item(String s) {
        Snippet.Kind kind;
        int marker = s.indexOf(MARKER);
        if (marker == -1) {
            if (s.isEmpty()) {
                return null;
            }
            if (s.charAt(0) == '/') {
                return new ShellHistory.Item(null, true, s);
            }
            return new ShellHistory.Item(Snippet.Kind.ERRONEOUS, false, s);
        }
        String k = s.substring(0, marker);
        String c = s.substring(marker + MARKER.length());
        if (KIND_COMMAND.equals(k)) {
            return new ShellHistory.Item(null, true, c);
        }
        try {
            kind = Snippet.Kind.valueOf(k);
        }
        catch (IllegalArgumentException ex) {
            kind = Snippet.Kind.ERRONEOUS;
        }
        return new ShellHistory.Item(kind, false, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushItems(List<ShellHistory.Item> newItems) {
        this.load();
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            this.items.addAll(newItems);
            if (this.items.size() > this.maxHistory) {
                this.items.removeAll(this.items.subList(0, this.items.size() - this.maxHistory));
            }
        }
        ChangeListener[] ll = null;
        FileHistory fileHistory2 = this;
        synchronized (fileHistory2) {
            if (!this.listeners.isEmpty()) {
                ll = newItems.toArray(new ChangeListener[newItems.size()]);
            }
        }
        if (ll != null) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener l) {
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener l) {
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected FileObject createFile() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            if (this.items != null) {
                return;
            }
        }
        if (this.historyFile == null) {
            this.items = new ArrayList<ShellHistory.Item>();
            return;
        }
        ArrayList<ShellHistory.Item> loadedItems = new ArrayList<ShellHistory.Item>();
        try {
            StringBuilder sb = new StringBuilder();
            boolean continuation = false;
            for (String s : this.historyFile.asLines()) {
                boolean from = false;
                if (continuation && !s.isEmpty() && s.charAt(0) == '\t') {
                    s = s.substring(1);
                }
                boolean bl = continuation = !s.isEmpty() && s.charAt(s.length() - 1) == '\\';
                if (!continuation) {
                    sb.append(s);
                    loadedItems.add(this.string2Item(sb.toString()));
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(s, 0, s.length() - 1);
                sb.append("\n");
            }
            if (continuation) {
                loadedItems.add(this.string2Item(sb.toString()));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)((IOException)Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO)), (String)"Unable to load shell history"));
        }
        FileHistory fileHistory2 = this;
        synchronized (fileHistory2) {
            if (this.items == null) {
                this.items = loadedItems;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        block17: {
            List<ShellHistory.Item> itemsToSave;
            try {
                this.load();
                if (this.historyFile == null) {
                    this.historyFile = this.createFile();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Unable to create history file", Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
                return;
            }
            FileHistory fileHistory = this;
            synchronized (fileHistory) {
                itemsToSave = this.items;
            }
            try (BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(this.historyFile.getOutputStream(), "UTF-8"));){
                for (ShellHistory.Item item : itemsToSave) {
                    String s = this.item2String(item);
                    String[] lines = s.split("\n");
                    int count = lines.length;
                    for (String l : lines) {
                        l.trim();
                        wr.write(l);
                        if (count != 1) {
                            wr.write("\\");
                            wr.newLine();
                            wr.write("\t");
                        } else {
                            wr.newLine();
                        }
                        --count;
                    }
                }
                wr.flush();
            }
            catch (IOException ex) {
                if (this.fileWarned) break block17;
                LOG.log(Level.INFO, "Unable to write history file", Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
                this.fileWarned = true;
            }
        }
    }
}

