/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.quicksearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.quicksearch.QuickSearchPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class NewQuickSearchIterator
extends BasicWizardIterator {
    private static final String[] HARDCODED_IMPORTS = new String[]{"org.netbeans.spi.quicksearch.SearchProvider", "org.netbeans.spi.quicksearch.SearchRequest", "org.netbeans.spi.quicksearch.SearchResponse"};
    private static final String lineSep = System.getProperty("line.separator");
    private DataModel data;

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new QuickSearchPanel(wiz, this.data)};
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewQuickSearchIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles cmf = new CreatedModifiedFiles(model.getProject());
        cmf.add(cmf.addModuleDependency("org.netbeans.spi.quicksearch"));
        String fileName = model.getClassName();
        FileObject template = CreatedModifiedFiles.getTemplate("quickSearch.java");
        assert (template != null);
        String actionPath = model.getDefaultPackagePath(fileName + ".java", false);
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CLASS_NAME", fileName);
        replaceTokens.put("PACKAGE_NAME", model.getPackageName());
        TreeSet<String> imports = new TreeSet<String>(Arrays.asList(HARDCODED_IMPORTS));
        StringBuffer importsBuffer = new StringBuffer();
        for (String imprt : imports) {
            importsBuffer.append("import " + imprt + ';' + lineSep);
        }
        replaceTokens.put("IMPORTS", importsBuffer.toString());
        cmf.add(cmf.createFileWithSubstitutions(actionPath, template, replaceTokens));
        String category = "QuickSearch/" + model.getCategoryName().replaceAll(" ", "");
        String dashedPkgName = model.getPackageName().replace('.', '-');
        String dashedFqClassName = dashedPkgName + '-' + fileName;
        String instanceFullPath = category + "/" + dashedFqClassName + ".instance";
        cmf.add(cmf.createLayerEntry(instanceFullPath, null, null, model.getCategoryName(), null));
        cmf.add(cmf.createLayerAttribute(category, "command", model.commandPrefix));
        cmf.add(cmf.createLayerAttribute(category, "position", model.getPosition()));
        model.setCreatedModifiedFiles(cmf);
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private CreatedModifiedFiles files;
        private String categoryName;
        private String commandPrefix;
        private String className;
        private int position;

        public DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        String getCategoryName() {
            return this.categoryName;
        }

        String getClassName() {
            return this.className;
        }

        String getCommandPrefix() {
            return this.commandPrefix;
        }

        Integer getPosition() {
            return this.position;
        }

        void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        void setClassName(String className) {
            this.className = className;
        }

        void setCommandPrefix(String commandPrefix) {
            this.commandPrefix = commandPrefix;
        }

        void setPosition(int parseInt) {
            this.position = parseInt;
        }
    }
}

