/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.payara.jakartaee.ide.Hk2PluginProperties;
import org.netbeans.modules.payara.tooling.data.PayaraLibrary;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilder;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class Hk2LibraryProvider {
    private static final Logger LOGGER = Logger.getLogger("payara-jakartaee");
    private static final String PROVIDER_TYPE = "j2se";
    private static final String JAVAEE_NAME_SUFFIX = " Java EE";
    private static final String MICROPROFILE_NAME_SUFFIX = " MicroProfile";
    private static final String JERSEY_NAME_SUFFIX = " Jersey";
    private static final String JAXRS_NAME_SUFFIX = " JAX-RS";
    private final Pattern JAVAEE_PATTERN = Pattern.compile("[jJ]ava {0,1}[eE]{2}");
    private final Pattern MICROPROFILE_PATTERN = Pattern.compile("[mM]icro[pP]rofile");
    private final Pattern JERSEY_PATTERN = Pattern.compile("[jJ]ersey.*");
    private final Pattern JAXRS_PATTERN = Pattern.compile("[jJ][aA][xX][ -]{0,1}[rR][sS]");
    static final String JAVAEE_DOC_CODE_BASE = "org.netbeans.modules.j2ee.platform";
    private static final Map<PayaraServer, Hk2LibraryProvider> providers = new HashMap<PayaraServer, Hk2LibraryProvider>();
    private volatile ConfigBuilder builder;
    private final String serverHome;
    private final String serverName;
    private final PayaraServer server;
    private volatile String javaEEName = null;
    private volatile String microProfileName = null;
    private volatile String jerseyName = null;
    private volatile String jaxRsName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hk2LibraryProvider getProvider(PayaraServer server) {
        Hk2LibraryProvider provider;
        Map<PayaraServer, Hk2LibraryProvider> map = providers;
        synchronized (map) {
            provider = providers.get(server);
            if (provider == null) {
                provider = new Hk2LibraryProvider(server);
                providers.put(server, provider);
            }
        }
        return provider;
    }

    private Hk2LibraryProvider(PayaraServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Payara server entity shall not be null.");
        }
        this.serverHome = server.getServerHome();
        this.serverName = server.getName();
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaEEName() {
        if (this.javaEEName != null) {
            return this.javaEEName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JAVAEE_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JAVAEE_NAME_SUFFIX);
            this.javaEEName = sb.toString();
        }
        return this.javaEEName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroProfileName() {
        if (this.microProfileName != null) {
            return this.microProfileName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + MICROPROFILE_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(MICROPROFILE_NAME_SUFFIX);
            this.microProfileName = sb.toString();
        }
        return this.microProfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJerseyName() {
        if (this.jerseyName != null) {
            return this.jerseyName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JERSEY_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JERSEY_NAME_SUFFIX);
            this.jerseyName = sb.toString();
        }
        return this.jerseyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJaxRsName() {
        if (this.jaxRsName != null) {
            return this.jaxRsName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JAXRS_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JAXRS_NAME_SUFFIX);
            this.jaxRsName = sb.toString();
        }
        return this.jaxRsName;
    }

    public Library getJerseyLibrary() {
        return this.getLibrary(this.JERSEY_PATTERN, this.getJerseyName());
    }

    public void setJerseyImplementation(LibraryImplementation lib, String libraryName) {
        this.setLibraryImplementationContent(lib, this.JERSEY_PATTERN, libraryName);
    }

    public List<URL> getJerseyClassPathURLs() {
        return this.getLibraryClassPathURLs(this.JERSEY_PATTERN);
    }

    public Library getJaxRsLibrary() {
        return this.getLibrary(this.JAXRS_PATTERN, this.getJaxRsName());
    }

    public void setJaxRsLibraryImplementation(LibraryImplementation lib, String libraryName) {
        this.setLibraryImplementationContent(lib, this.JAXRS_PATTERN, libraryName);
    }

    public List<URL> getJaxRsClassPathURLs() {
        return this.getLibraryClassPathURLs(this.JAXRS_PATTERN);
    }

    public Library getJavaEELibrary() {
        return this.getLibrary(this.JAVAEE_PATTERN, this.getJavaEEName());
    }

    public Library getMicroProfileLibrary() {
        return this.getLibrary(this.MICROPROFILE_PATTERN, this.getMicroProfileName());
    }

    public void setJavaEELibraryImplementation(LibraryImplementation lib, String libraryName) {
        this.setLibraryImplementationContent(lib, this.JAVAEE_PATTERN, libraryName);
    }

    public List<URL> getJavaEEClassPathURLs() {
        return this.getLibraryClassPathURLs(this.JAVAEE_PATTERN);
    }

    public List<URL> getMicroProfileClassPathURLs() {
        return this.getLibraryClassPathURLs(this.MICROPROFILE_PATTERN);
    }

    private Library getLibrary(Pattern namePattern, String libraryName) {
        Library lib = LibraryManager.getDefault().getLibrary(libraryName);
        if (lib != null) {
            return lib;
        }
        ConfigBuilder cb = ConfigBuilderProvider.getBuilder((PayaraServer)this.server);
        List gfLibs = cb.getPlatformLibraries(this.server.getPlatformVersion());
        for (PayaraLibrary gfLib : gfLibs) {
            if (!namePattern.matcher(gfLib.getLibraryID()).matches()) continue;
            HashMap<String, List<URL>> contents = new HashMap<String, List<URL>>(1);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            contents.put("classpath", this.translateArchiveUrls(gfLib.getClasspath()));
            contents.put("javadoc", this.translateArchiveUrls(gfLib.getJavadocs()));
            properties.put("maven-dependencies", gfLib.getMavenDeps());
            properties.put("maven-repositories", "default");
            try {
                return LibraryManager.getDefault().createLibrary(PROVIDER_TYPE, libraryName, null, null, contents, properties);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Could not create Jersey library for " + this.serverName + ": ", ioe);
            }
        }
        return null;
    }

    private void setLibraryImplementationContent(LibraryImplementation lib, Pattern namePattern, String libraryName) {
        ConfigBuilder cb = ConfigBuilderProvider.getBuilder((PayaraServer)this.server);
        List pfLibs = cb.getPlatformLibraries(this.server.getPlatformVersion());
        for (PayaraLibrary pfLib : pfLibs) {
            if (!namePattern.matcher(pfLib.getLibraryID()).matches()) continue;
            List javadocLookups = pfLib.getJavadocLookups();
            lib.setName(libraryName);
            ArrayList<URL> cp = new ArrayList<URL>();
            for (URL url : pfLib.getClasspath()) {
                if (FileUtil.isArchiveFile((URL)url)) {
                    cp.add(FileUtil.getArchiveRoot((URL)url));
                    continue;
                }
                cp.add(url);
            }
            ArrayList<URL> javadoc = new ArrayList<URL>();
            if (javadocLookups != null) {
                for (String lookup : javadocLookups) {
                    try {
                        File j2eeDoc = InstalledFileLocator.getDefault().locate(lookup, JAVAEE_DOC_CODE_BASE, false);
                        if (j2eeDoc == null) continue;
                        javadoc.add(Hk2PluginProperties.fileToUrl(j2eeDoc));
                    }
                    catch (MalformedURLException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            }
            lib.setContent("classpath", cp);
            lib.setContent("javadoc", javadoc);
        }
    }

    private List<URL> getLibraryClassPathURLs(Pattern namePattern) {
        ConfigBuilder cb = ConfigBuilderProvider.getBuilder((PayaraServer)this.server);
        List pfLibs = cb.getPlatformLibraries(this.server.getPlatformVersion());
        for (PayaraLibrary pfLib : pfLibs) {
            if (!namePattern.matcher(pfLib.getLibraryID()).matches()) continue;
            return pfLib.getClasspath();
        }
        return Collections.emptyList();
    }

    private List<URL> translateArchiveUrls(List<URL> urls) {
        ArrayList<URL> result = new ArrayList<URL>(urls.size());
        for (URL u : urls) {
            if (FileUtil.isArchiveFile((URL)u)) {
                result.add(FileUtil.getArchiveRoot((URL)u));
                continue;
            }
            result.add(u);
        }
        return result;
    }
}

