/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.exception;

import com.google.common.base.Preconditions;
import com.oracle.bmc.auth.exception.AuthClientException;
import com.oracle.bmc.model.BmcException;

public class AuthClientNotAuthorizedException
extends AuthClientException {
    private static final int STATUS_CODE_UNAUTHORIZED = 401;
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE = "Client is unauthorized. ";

    public AuthClientNotAuthorizedException(BmcException e) {
        this(MESSAGE + e.getMessage(), e);
    }

    public AuthClientNotAuthorizedException(String message, BmcException cause) {
        super(message, AuthClientNotAuthorizedException.validate(cause));
    }

    private static BmcException validate(BmcException cause) {
        Preconditions.checkArgument((boolean)AuthClientNotAuthorizedException.matches(cause));
        return cause;
    }

    public static boolean matches(BmcException cause) {
        return cause.getStatusCode() == 401;
    }
}

