/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Objects;
import java.util.zip.Checksum;
import org.netbeans.modules.autoupdate.services.MessageValidator;

public class MessageChecksumValidator
implements MessageValidator {
    private final Checksum checksum;
    private final long expectedValue;
    private Long digestValue;

    public MessageChecksumValidator(Checksum checksum, long expectedValue) {
        Objects.requireNonNull(checksum, "messageDigenst must not be NULL");
        Objects.requireNonNull(Long.valueOf(expectedValue), "expectedValue must not be NULL");
        this.checksum = checksum;
        this.expectedValue = expectedValue;
    }

    @Override
    public void update(byte b) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.checksum.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.checksum.update(b, off, len);
    }

    @Override
    public void update(byte[] input) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.update(input, 0, input.length);
    }

    @Override
    public boolean isValid() {
        return this.getDigestValue() == this.expectedValue;
    }

    private long getDigestValue() {
        if (this.digestValue == null) {
            this.digestValue = this.checksum.getValue();
        }
        return this.digestValue;
    }

    @Override
    public String getName() {
        return "Checksum " + this.checksum.getClass().getSimpleName();
    }

    @Override
    public String getExpectedValueAsString() {
        return Long.toString(this.expectedValue);
    }

    @Override
    public String getRealValueAsString() {
        return Long.toString(this.checksum.getValue());
    }

    @Override
    public void reset() {
        this.checksum.reset();
        this.digestValue = null;
    }
}

