/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.OAuth2ClientCredential;
import com.oracle.bmc.identity.requests.UpdateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.responses.UpdateOAuthClientCredentialResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOAuthClientCredentialConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateOAuthClientCredentialConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateOAuthClientCredentialRequest interceptRequest(UpdateOAuthClientCredentialRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateOAuthClientCredentialRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOauth2ClientCredentialId(), (String)"oauth2ClientCredentialId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateOAuth2ClientCredentialDetails(), (String)"updateOAuth2ClientCredentialDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment((String)request.getUserId())).path("oauth2ClientCredentials").path(HttpUtils.encodePathSegment((String)request.getOauth2ClientCredentialId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, UpdateOAuthClientCredentialResponse> fromResponse() {
        Function<Response, UpdateOAuthClientCredentialResponse> transformer = new Function<Response, UpdateOAuthClientCredentialResponse>(){

            public UpdateOAuthClientCredentialResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.UpdateOAuthClientCredentialResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(OAuth2ClientCredential.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateOAuthClientCredentialResponse.Builder builder = UpdateOAuthClientCredentialResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.oAuth2ClientCredential((OAuth2ClientCredential)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                UpdateOAuthClientCredentialResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

