/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.IamWorkRequest;
import com.oracle.bmc.identity.requests.GetIamWorkRequestRequest;
import com.oracle.bmc.identity.responses.GetIamWorkRequestResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetIamWorkRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetIamWorkRequestConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetIamWorkRequestRequest interceptRequest(GetIamWorkRequestRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetIamWorkRequestRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIamWorkRequestId(), (String)"iamWorkRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("iamWorkRequests").path(HttpUtils.encodePathSegment((String)request.getIamWorkRequestId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetIamWorkRequestResponse> fromResponse() {
        Function<Response, GetIamWorkRequestResponse> transformer = new Function<Response, GetIamWorkRequestResponse>(){

            public GetIamWorkRequestResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.GetIamWorkRequestResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(IamWorkRequest.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetIamWorkRequestResponse.Builder builder = GetIamWorkRequestResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.iamWorkRequest((IamWorkRequest)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetIamWorkRequestResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

