/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.Domain;
import com.oracle.bmc.identity.model.DynamicGroup;
import com.oracle.bmc.identity.model.Group;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.model.Policy;
import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.identity.model.TagDefault;
import com.oracle.bmc.identity.model.TagNamespace;
import com.oracle.bmc.identity.model.User;
import com.oracle.bmc.identity.model.UserGroupMembership;
import com.oracle.bmc.identity.requests.GetCompartmentRequest;
import com.oracle.bmc.identity.requests.GetDomainRequest;
import com.oracle.bmc.identity.requests.GetDynamicGroupRequest;
import com.oracle.bmc.identity.requests.GetGroupRequest;
import com.oracle.bmc.identity.requests.GetIamWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetIdentityProviderRequest;
import com.oracle.bmc.identity.requests.GetIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.GetPolicyRequest;
import com.oracle.bmc.identity.requests.GetTagDefaultRequest;
import com.oracle.bmc.identity.requests.GetTagNamespaceRequest;
import com.oracle.bmc.identity.requests.GetTagRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetUserGroupMembershipRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.GetWorkRequestRequest;
import com.oracle.bmc.identity.responses.GetCompartmentResponse;
import com.oracle.bmc.identity.responses.GetDomainResponse;
import com.oracle.bmc.identity.responses.GetDynamicGroupResponse;
import com.oracle.bmc.identity.responses.GetGroupResponse;
import com.oracle.bmc.identity.responses.GetIamWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetIdentityProviderResponse;
import com.oracle.bmc.identity.responses.GetIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.GetPolicyResponse;
import com.oracle.bmc.identity.responses.GetTagDefaultResponse;
import com.oracle.bmc.identity.responses.GetTagNamespaceResponse;
import com.oracle.bmc.identity.responses.GetTagResponse;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetUserGroupMembershipResponse;
import com.oracle.bmc.identity.responses.GetUserResponse;
import com.oracle.bmc.identity.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class IdentityWaiters {
    private final ExecutorService executorService;
    private final Identity client;

    public Waiter<GetCompartmentRequest, GetCompartmentResponse> forCompartment(GetCompartmentRequest request, Compartment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCompartment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCompartmentRequest, GetCompartmentResponse> forCompartment(GetCompartmentRequest request, Compartment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCompartment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCompartmentRequest, GetCompartmentResponse> forCompartment(GetCompartmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Compartment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCompartment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCompartmentRequest, GetCompartmentResponse> forCompartment(BmcGenericWaiter waiter, GetCompartmentRequest request, Compartment.LifecycleState ... targetStates) {
        final HashSet<Compartment.LifecycleState> targetStatesSet = new HashSet<Compartment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCompartmentRequest, GetCompartmentResponse>(){

            public GetCompartmentResponse apply(GetCompartmentRequest request) {
                return IdentityWaiters.this.client.getCompartment(request);
            }
        }, (Predicate)new Predicate<GetCompartmentResponse>(){

            public boolean apply(GetCompartmentResponse response) {
                return targetStatesSet.contains((Object)response.getCompartment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Compartment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, Domain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDomain(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, Domain.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Domain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDomainRequest, GetDomainResponse> forDomain(BmcGenericWaiter waiter, GetDomainRequest request, Domain.LifecycleState ... targetStates) {
        final HashSet<Domain.LifecycleState> targetStatesSet = new HashSet<Domain.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDomainRequest, GetDomainResponse>(){

            public GetDomainResponse apply(GetDomainRequest request) {
                return IdentityWaiters.this.client.getDomain(request);
            }
        }, (Predicate)new Predicate<GetDomainResponse>(){

            public boolean apply(GetDomainResponse response) {
                return targetStatesSet.contains((Object)response.getDomain().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetDynamicGroupRequest, GetDynamicGroupResponse> forDynamicGroup(GetDynamicGroupRequest request, DynamicGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDynamicGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDynamicGroupRequest, GetDynamicGroupResponse> forDynamicGroup(GetDynamicGroupRequest request, DynamicGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDynamicGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDynamicGroupRequest, GetDynamicGroupResponse> forDynamicGroup(GetDynamicGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DynamicGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDynamicGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDynamicGroupRequest, GetDynamicGroupResponse> forDynamicGroup(BmcGenericWaiter waiter, GetDynamicGroupRequest request, DynamicGroup.LifecycleState ... targetStates) {
        final HashSet<DynamicGroup.LifecycleState> targetStatesSet = new HashSet<DynamicGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDynamicGroupRequest, GetDynamicGroupResponse>(){

            public GetDynamicGroupResponse apply(GetDynamicGroupRequest request) {
                return IdentityWaiters.this.client.getDynamicGroup(request);
            }
        }, (Predicate)new Predicate<GetDynamicGroupResponse>(){

            public boolean apply(GetDynamicGroupResponse response) {
                return targetStatesSet.contains((Object)response.getDynamicGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DynamicGroup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetGroupRequest, GetGroupResponse> forGroup(GetGroupRequest request, Group.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGroupRequest, GetGroupResponse> forGroup(GetGroupRequest request, Group.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGroupRequest, GetGroupResponse> forGroup(GetGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Group.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGroupRequest, GetGroupResponse> forGroup(BmcGenericWaiter waiter, GetGroupRequest request, Group.LifecycleState ... targetStates) {
        final HashSet<Group.LifecycleState> targetStatesSet = new HashSet<Group.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetGroupRequest, GetGroupResponse>(){

            public GetGroupResponse apply(GetGroupRequest request) {
                return IdentityWaiters.this.client.getGroup(request);
            }
        }, (Predicate)new Predicate<GetGroupResponse>(){

            public boolean apply(GetGroupResponse response) {
                return targetStatesSet.contains((Object)response.getGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Group.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetIamWorkRequestRequest, GetIamWorkRequestResponse> forIamWorkRequest(GetIamWorkRequestRequest request) {
        return this.forIamWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetIamWorkRequestRequest, GetIamWorkRequestResponse> forIamWorkRequest(GetIamWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forIamWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetIamWorkRequestRequest, GetIamWorkRequestResponse> forIamWorkRequest(BmcGenericWaiter waiter, GetIamWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetIamWorkRequestRequest, GetIamWorkRequestResponse>(){

            public GetIamWorkRequestResponse apply(GetIamWorkRequestRequest request) {
                return IdentityWaiters.this.client.getIamWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetIamWorkRequestResponse>(){

            public boolean apply(GetIamWorkRequestResponse response) {
                return response.getIamWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetIdentityProviderRequest, GetIdentityProviderResponse> forIdentityProvider(GetIdentityProviderRequest request, IdentityProvider.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIdentityProvider(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIdentityProviderRequest, GetIdentityProviderResponse> forIdentityProvider(GetIdentityProviderRequest request, IdentityProvider.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIdentityProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIdentityProviderRequest, GetIdentityProviderResponse> forIdentityProvider(GetIdentityProviderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IdentityProvider.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIdentityProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIdentityProviderRequest, GetIdentityProviderResponse> forIdentityProvider(BmcGenericWaiter waiter, GetIdentityProviderRequest request, IdentityProvider.LifecycleState ... targetStates) {
        final HashSet<IdentityProvider.LifecycleState> targetStatesSet = new HashSet<IdentityProvider.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetIdentityProviderRequest, GetIdentityProviderResponse>(){

            public GetIdentityProviderResponse apply(GetIdentityProviderRequest request) {
                return IdentityWaiters.this.client.getIdentityProvider(request);
            }
        }, (Predicate)new Predicate<GetIdentityProviderResponse>(){

            public boolean apply(GetIdentityProviderResponse response) {
                return targetStatesSet.contains((Object)response.getIdentityProvider().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IdentityProvider.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> forIdpGroupMapping(GetIdpGroupMappingRequest request, IdpGroupMapping.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIdpGroupMapping(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> forIdpGroupMapping(GetIdpGroupMappingRequest request, IdpGroupMapping.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIdpGroupMapping(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> forIdpGroupMapping(GetIdpGroupMappingRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IdpGroupMapping.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIdpGroupMapping(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> forIdpGroupMapping(BmcGenericWaiter waiter, GetIdpGroupMappingRequest request, IdpGroupMapping.LifecycleState ... targetStates) {
        final HashSet<IdpGroupMapping.LifecycleState> targetStatesSet = new HashSet<IdpGroupMapping.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse>(){

            public GetIdpGroupMappingResponse apply(GetIdpGroupMappingRequest request) {
                return IdentityWaiters.this.client.getIdpGroupMapping(request);
            }
        }, (Predicate)new Predicate<GetIdpGroupMappingResponse>(){

            public boolean apply(GetIdpGroupMappingResponse response) {
                return targetStatesSet.contains((Object)response.getIdpGroupMapping().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IdpGroupMapping.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPolicyRequest, GetPolicyResponse> forPolicy(GetPolicyRequest request, Policy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPolicyRequest, GetPolicyResponse> forPolicy(GetPolicyRequest request, Policy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPolicyRequest, GetPolicyResponse> forPolicy(GetPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Policy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPolicyRequest, GetPolicyResponse> forPolicy(BmcGenericWaiter waiter, GetPolicyRequest request, Policy.LifecycleState ... targetStates) {
        final HashSet<Policy.LifecycleState> targetStatesSet = new HashSet<Policy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetPolicyRequest, GetPolicyResponse>(){

            public GetPolicyResponse apply(GetPolicyRequest request) {
                return IdentityWaiters.this.client.getPolicy(request);
            }
        }, (Predicate)new Predicate<GetPolicyResponse>(){

            public boolean apply(GetPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Policy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTagRequest, GetTagResponse> forTag(GetTagRequest request, Tag.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTag(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTagRequest, GetTagResponse> forTag(GetTagRequest request, Tag.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTagRequest, GetTagResponse> forTag(GetTagRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Tag.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTagRequest, GetTagResponse> forTag(BmcGenericWaiter waiter, GetTagRequest request, Tag.LifecycleState ... targetStates) {
        final HashSet<Tag.LifecycleState> targetStatesSet = new HashSet<Tag.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTagRequest, GetTagResponse>(){

            public GetTagResponse apply(GetTagRequest request) {
                return IdentityWaiters.this.client.getTag(request);
            }
        }, (Predicate)new Predicate<GetTagResponse>(){

            public boolean apply(GetTagResponse response) {
                return targetStatesSet.contains((Object)response.getTag().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Tag.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTagDefaultRequest, GetTagDefaultResponse> forTagDefault(GetTagDefaultRequest request, TagDefault.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTagDefault(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTagDefaultRequest, GetTagDefaultResponse> forTagDefault(GetTagDefaultRequest request, TagDefault.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTagDefault(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTagDefaultRequest, GetTagDefaultResponse> forTagDefault(GetTagDefaultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TagDefault.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTagDefault(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTagDefaultRequest, GetTagDefaultResponse> forTagDefault(BmcGenericWaiter waiter, GetTagDefaultRequest request, TagDefault.LifecycleState ... targetStates) {
        final HashSet<TagDefault.LifecycleState> targetStatesSet = new HashSet<TagDefault.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTagDefaultRequest, GetTagDefaultResponse>(){

            public GetTagDefaultResponse apply(GetTagDefaultRequest request) {
                return IdentityWaiters.this.client.getTagDefault(request);
            }
        }, (Predicate)new Predicate<GetTagDefaultResponse>(){

            public boolean apply(GetTagDefaultResponse response) {
                return targetStatesSet.contains((Object)response.getTagDefault().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetTagNamespaceRequest, GetTagNamespaceResponse> forTagNamespace(GetTagNamespaceRequest request, TagNamespace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTagNamespace(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTagNamespaceRequest, GetTagNamespaceResponse> forTagNamespace(GetTagNamespaceRequest request, TagNamespace.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTagNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTagNamespaceRequest, GetTagNamespaceResponse> forTagNamespace(GetTagNamespaceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TagNamespace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTagNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTagNamespaceRequest, GetTagNamespaceResponse> forTagNamespace(BmcGenericWaiter waiter, GetTagNamespaceRequest request, TagNamespace.LifecycleState ... targetStates) {
        final HashSet<TagNamespace.LifecycleState> targetStatesSet = new HashSet<TagNamespace.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTagNamespaceRequest, GetTagNamespaceResponse>(){

            public GetTagNamespaceResponse apply(GetTagNamespaceRequest request) {
                return IdentityWaiters.this.client.getTagNamespace(request);
            }
        }, (Predicate)new Predicate<GetTagNamespaceResponse>(){

            public boolean apply(GetTagNamespaceResponse response) {
                return targetStatesSet.contains((Object)response.getTagNamespace().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TagNamespace.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> forTaggingWorkRequest(GetTaggingWorkRequestRequest request) {
        return this.forTaggingWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> forTaggingWorkRequest(GetTaggingWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forTaggingWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> forTaggingWorkRequest(BmcGenericWaiter waiter, GetTaggingWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse>(){

            public GetTaggingWorkRequestResponse apply(GetTaggingWorkRequestRequest request) {
                return IdentityWaiters.this.client.getTaggingWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetTaggingWorkRequestResponse>(){

            public boolean apply(GetTaggingWorkRequestResponse response) {
                return response.getTaggingWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetUserRequest, GetUserResponse> forUser(GetUserRequest request, User.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUser(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUserRequest, GetUserResponse> forUser(GetUserRequest request, User.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUser(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUserRequest, GetUserResponse> forUser(GetUserRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, User.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forUser(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUserRequest, GetUserResponse> forUser(BmcGenericWaiter waiter, GetUserRequest request, User.LifecycleState ... targetStates) {
        final HashSet<User.LifecycleState> targetStatesSet = new HashSet<User.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetUserRequest, GetUserResponse>(){

            public GetUserResponse apply(GetUserRequest request) {
                return IdentityWaiters.this.client.getUser(request);
            }
        }, (Predicate)new Predicate<GetUserResponse>(){

            public boolean apply(GetUserResponse response) {
                return targetStatesSet.contains((Object)response.getUser().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)User.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> forUserGroupMembership(GetUserGroupMembershipRequest request, UserGroupMembership.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUserGroupMembership(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> forUserGroupMembership(GetUserGroupMembershipRequest request, UserGroupMembership.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUserGroupMembership(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> forUserGroupMembership(GetUserGroupMembershipRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, UserGroupMembership.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forUserGroupMembership(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> forUserGroupMembership(BmcGenericWaiter waiter, GetUserGroupMembershipRequest request, UserGroupMembership.LifecycleState ... targetStates) {
        final HashSet<UserGroupMembership.LifecycleState> targetStatesSet = new HashSet<UserGroupMembership.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse>(){

            public GetUserGroupMembershipResponse apply(GetUserGroupMembershipRequest request) {
                return IdentityWaiters.this.client.getUserGroupMembership(request);
            }
        }, (Predicate)new Predicate<GetUserGroupMembershipResponse>(){

            public boolean apply(GetUserGroupMembershipResponse response) {
                return targetStatesSet.contains((Object)response.getUserGroupMembership().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)UserGroupMembership.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return IdentityWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public IdentityWaiters(ExecutorService executorService, Identity client) {
        this.executorService = executorService;
        this.client = client;
    }
}

