/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.APIAccessor;
import org.netbeans.modules.java.hints.declarative.Bundle;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeFix;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;

class DeclarativeHintsWorker
implements HintDescription.Worker {
    private final String displayName;
    private final String pattern;
    private final List<Condition> conditions;
    private final String imports;
    private final List<DeclarativeFix> fixes;
    private final Map<String, String> options;

    public DeclarativeHintsWorker(String displayName, String pattern, List<Condition> conditions, String imports, List<DeclarativeFix> fixes, Map<String, String> options) {
        this.displayName = displayName;
        this.pattern = pattern;
        this.conditions = conditions;
        this.imports = imports;
        this.fixes = fixes;
        this.options = options;
    }

    String getDisplayName() {
        return this.displayName;
    }

    List<DeclarativeFix> getFixes() {
        return this.fixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
        void var4_8;
        ErrorDescription ed;
        Tree parsedPattern;
        Context context = new Context(ctx);
        context.enterScope();
        for (Condition condition : this.conditions) {
            if (condition.holds(context, true)) continue;
            return null;
        }
        LinkedList<Fix> editorFixes = new LinkedList<Fix>();
        block6: for (DeclarativeFix fix : this.fixes) {
            context.enterScope();
            try {
                boolean empty;
                for (Condition c : fix.getConditions()) {
                    if (c instanceof Condition.Otherwise) {
                        if (!editorFixes.isEmpty()) continue block6;
                        continue;
                    }
                    if (!c.holds(context, false)) continue block6;
                }
                DeclarativeHintsWorker.reportErrorWarning(ctx, fix.getOptions());
                TokenSequence ts = TokenHierarchy.create((CharSequence)fix.getPattern(), (boolean)false, DeclarativeHintTokenId.language(), EnumSet.of(DeclarativeHintTokenId.BLOCK_COMMENT, DeclarativeHintTokenId.LINE_COMMENT, DeclarativeHintTokenId.WHITESPACE), null).tokenSequence(DeclarativeHintTokenId.language());
                boolean bl = empty = !ts.moveNext();
                if (empty) {
                    if ((fix.getOptions().containsKey("error") || fix.getOptions().containsKey("warning")) && !fix.getOptions().containsKey("remove-from-parent")) continue;
                    editorFixes.add(JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveFromParent(ctx.getPath().getLeaf().toString()), (TreePath)ctx.getPath()));
                    continue;
                }
                editorFixes.add(JavaFixImpl.Accessor.INSTANCE.rewriteFix(ctx.getInfo(), fix.getDisplayName(), ctx.getPath(), fix.getPattern(), APIAccessor.IMPL.getVariables(context), APIAccessor.IMPL.getMultiVariables(context), APIAccessor.IMPL.getVariableNames(context), ctx.getConstraints(), fix.getOptions(), new String[]{this.imports}));
            }
            finally {
                context.leaveScope();
            }
        }
        context.leaveScope();
        Tree tree = ctx.getPath().getLeaf();
        if (tree.getKind() == Tree.Kind.BLOCK && Utilities.isFakeBlock((Tree)(parsedPattern = Utilities.parseAndAttribute((CompilationInfo)ctx.getInfo(), (String)this.pattern, null)))) {
            BlockTree errorBlock;
            int skip;
            String leadingName;
            BlockTree fakeBlock = (BlockTree)parsedPattern;
            Tree firstStatement = !fakeBlock.getStatements().isEmpty() ? (Tree)fakeBlock.getStatements().get(0) : null;
            String string = leadingName = firstStatement != null ? Utilities.getWildcardTreeName((Tree)firstStatement).toString() : null;
            if (leadingName != null && (skip = ctx.getMultiVariables().get(leadingName) != null ? ((Collection)ctx.getMultiVariables().get(leadingName)).size() : (ctx.getVariables().get(leadingName) != null ? 1 : 0)) < (errorBlock = (BlockTree)tree).getStatements().size()) {
                Tree tree2 = errorBlock.getStatements().get(skip);
            }
        }
        if ((ed = ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)var4_8, (String)this.displayName, (Fix[])editorFixes.toArray(new Fix[0]))) == null) {
            return null;
        }
        return Collections.singletonList(ed);
    }

    private static void reportErrorWarning(HintContext ctx, Map<String, String> options) {
        String warningText;
        String errorText = options.get("error");
        if (errorText != null) {
            ctx.reportMessage(HintContext.MessageKind.ERROR, errorText);
        }
        if ((warningText = options.get("warning")) != null) {
            ctx.reportMessage(HintContext.MessageKind.WARNING, warningText);
        }
    }
}

