/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.utils;

import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public final class GroovyUtils {
    private static volatile boolean indexingEnabled = Boolean.valueOf(System.getProperty("org.netbeans.modules.groovy.editor.api.indexingEnabled", "true"));

    private GroovyUtils() {
    }

    public static String stripPackage(String fqn) {
        if (fqn.endsWith("...") && fqn.length() > 3) {
            return GroovyUtils.stripPackage(fqn.substring(0, fqn.length() - 3)) + "...";
        }
        if (fqn.contains("<")) {
            int first = fqn.indexOf(60);
            int last = fqn.lastIndexOf(62);
            if (last > first) {
                return GroovyUtils.stripPackage(fqn.substring(0, first)) + "<" + GroovyUtils.stripPackageFromTypeParams(fqn.substring(first + 1, last)) + ">" + fqn.substring(last + 1, fqn.length());
            }
        }
        if (fqn.contains(".")) {
            int idx = fqn.lastIndexOf(".");
            fqn = fqn.substring(idx + 1);
        }
        return fqn.replace(";", "");
    }

    public static String stripClassName(String fqn) {
        if (!fqn.contains(".")) {
            return "";
        }
        return fqn.substring(0, fqn.lastIndexOf(".") + 1);
    }

    public static String getPackageName(String fqn) {
        if (!fqn.contains(".")) {
            return "";
        }
        return fqn.substring(0, fqn.lastIndexOf("."));
    }

    public static boolean isRowWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            for (i = offset; i < text.length() && (c = text.charAt(i)) != '\n'; ++i) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (i = offset - 1; i >= 0 && (c = text.charAt(i)) != '\n'; --i) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static boolean isRowEmpty(String text, int offset) throws BadLocationException {
        try {
            char c;
            if (offset < text.length() && (c = text.charAt(offset)) != '\n' && (c != '\r' || offset != text.length() - 1 && text.charAt(offset + 1) != '\n')) {
                return false;
            }
            return offset == 0 || text.charAt(offset - 1) == '\n';
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowLastNonWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            for (i = offset; i < text.length() && (c = text.charAt(i)) != '\n' && (c != '\r' || i != text.length() - 1 && text.charAt(i + 1) != '\n'); ++i) {
            }
            --i;
            while (i >= 0) {
                c = text.charAt(i);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowFirstNonWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            if (i < text.length()) {
                for (i = offset - 1; i >= 0 && (c = text.charAt(i)) != '\n'; --i) {
                }
                ++i;
            }
            while (i < text.length()) {
                c = text.charAt(i);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowStart(String text, int offset) throws BadLocationException {
        try {
            for (int i = offset - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    private static BadLocationException getBadLocationException(IndexOutOfBoundsException ex, String text, int offset) {
        BadLocationException ble = new BadLocationException(offset + " out of " + text.length(), offset);
        ble.initCause(ex);
        return ble;
    }

    private static String stripPackageFromTypeParams(String params) {
        StringBuilder sb = new StringBuilder();
        for (String param : params.split(",")) {
            int idx;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((idx = param.indexOf("extends ")) < 0) {
                idx = param.indexOf("super ");
                if (idx < 0) {
                    sb.append(GroovyUtils.stripPackage(param));
                    continue;
                }
                sb.append(param.substring(0, idx + 6));
                sb.append(GroovyUtils.stripPackage(param.substring(idx + 6)));
                continue;
            }
            sb.append(param.substring(0, idx + 8));
            sb.append(GroovyUtils.stripPackage(param.substring(idx + 8)));
        }
        return sb.toString();
    }

    public static ClassNode findInferredType(ASTNode n) {
        Object o = n.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        ClassNode cn = null;
        if (n instanceof Expression) {
            cn = ((Expression)n).getType();
        }
        ClassNode inferred = null;
        if (o instanceof ClassNode) {
            inferred = (ClassNode)o;
        }
        if (inferred != null) {
            cn = inferred;
        }
        if (cn == null) {
            return null;
        }
        if (!cn.getName().equals("java.lang.Object")) {
            return cn;
        }
        return null;
    }

    public static void setIndexingEnabled(boolean enabled) {
        indexingEnabled = enabled;
    }

    public static boolean isIndexingEnabled() {
        return indexingEnabled;
    }
}

