/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements.ast;

import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.elements.ast.ASTElement;
import org.netbeans.modules.groovy.editor.api.elements.common.MethodElement;

public class ASTMethod
extends ASTElement
implements MethodElement {
    private List<MethodElement.MethodParameter> parameters;
    private String returnType;
    private Class clz;
    private MetaMethod method;
    private boolean isGDK;

    public ASTMethod(ASTNode node) {
        this(node, null);
    }

    public ASTMethod(ASTNode node, String in) {
        super(node, in);
    }

    public ASTMethod(ASTNode node, Class clz, MetaMethod method, boolean isGDK) {
        super(node);
        this.clz = clz;
        this.method = method;
        this.isGDK = isGDK;
    }

    public boolean isGDK() {
        return this.isGDK;
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    public Class getClz() {
        return this.clz;
    }

    @Override
    public List<MethodElement.MethodParameter> getParameters() {
        block7: {
            if (this.parameters != null) break block7;
            this.parameters = new ArrayList<MethodElement.MethodParameter>();
            if (this.method != null) {
                for (CachedClass pt : this.method.getParameterTypes()) {
                    String n = pt.getName();
                    int idx = n.lastIndexOf(36);
                    if (idx > 0) {
                        n = n.substring(idx + 1);
                    } else {
                        idx = n.lastIndexOf(46);
                        if (idx > 0) {
                            n = n.substring(idx + 1);
                        }
                    }
                    MethodElement.MethodParameter mp = new MethodElement.MethodParameter(pt.getName(), n, null);
                    this.parameters.add(mp);
                }
            } else {
                for (Parameter parameter : ((MethodNode)this.node).getParameters()) {
                    String paramName = parameter.getName();
                    String fqnType = parameter.getType().getName();
                    String type = ASTUtils.getSimpleName(parameter.getType());
                    this.parameters.add(new MethodElement.MethodParameter(fqnType, type, paramName));
                }
            }
        }
        return this.parameters;
    }

    @Override
    public List<String> getParameterTypes() {
        ArrayList<String> paramTypes = new ArrayList<String>();
        for (MethodElement.MethodParameter parameter : this.getParameters()) {
            paramTypes.add(parameter.getType());
        }
        return paramTypes;
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            if (this.method != null) {
                String s = this.method.getSignature();
                int sp = s.indexOf(32);
                this.signature = sp == -1 ? s : s.substring(sp + 1).trim();
            } else {
                StringBuilder builder = new StringBuilder(super.getSignature());
                List<MethodElement.MethodParameter> params = this.getParameters();
                if (params.size() > 0) {
                    builder.append("(");
                    for (MethodElement.MethodParameter parameter : params) {
                        builder.append(parameter.getFqnType());
                        builder.append(",");
                    }
                    builder.setLength(builder.length() - 1);
                    builder.append(")");
                }
                this.signature = builder.toString();
            }
        }
        return this.signature;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.node instanceof ConstructorNode) {
                this.name = ASTUtils.getSimpleName(((ConstructorNode)this.node).getDeclaringClass());
            } else if (this.node instanceof MethodNode) {
                this.name = ((MethodNode)this.node).getName();
            }
            if (this.name == null) {
                this.name = this.node.toString();
            }
        }
        return this.name;
    }

    @Override
    public String getReturnType() {
        if (this.returnType == null) {
            this.returnType = ASTUtils.getSimpleName(((MethodNode)this.node).getReturnType());
        }
        return this.returnType;
    }

    @Override
    public ElementKind getKind() {
        if (this.node instanceof ConstructorNode) {
            return ElementKind.CONSTRUCTOR;
        }
        if (this.node instanceof MethodNode) {
            return ElementKind.METHOD;
        }
        return ElementKind.OTHER;
    }
}

