/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.MavenDependencyNode;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class MavenAction
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(DependencyGraphScene.class);
    protected final GraphNode<MavenDependencyNode> node;
    protected final POMModel model;
    protected final DependencyGraphScene<MavenDependencyNode> scene;
    protected final GraphNode<MavenDependencyNode> rootNode;
    protected final Artifact nodeArtif;
    private final Project nbProject;
    private final DependencyGraphTopComponent ownerTC;

    protected MavenAction(DependencyGraphTopComponent ownerTC, DependencyGraphScene scene, GraphNode<MavenDependencyNode> rootNode, GraphNode<MavenDependencyNode> node, POMModel model, Project nbProject) {
        this.node = node;
        this.nodeArtif = ((MavenDependencyNode)node.getImpl()).getArtifact();
        this.model = model;
        this.scene = scene;
        this.rootNode = rootNode;
        this.nbProject = nbProject;
        this.ownerTC = ownerTC;
    }

    protected void save() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    MavenAction.this.ownerTC.saveChanges(MavenAction.this.model);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    protected void excludeDepFromModel(MavenDependencyNode node, Set<Artifact> exclTargets) {
        assert (this.model.isIntransaction()) : "Must be called inside transaction";
        Artifact nodeArtif = node.getArtifact();
        for (Artifact eTarget : exclTargets) {
            Exclusion ex;
            Dependency dep = this.model.getProject().findDependencyById(eTarget.getGroupId(), eTarget.getArtifactId(), null);
            if (dep == null) {
                ArrayList<String> profileNames = new ArrayList<String>();
                NbMavenProject nbMavproject = (NbMavenProject)this.nbProject.getLookup().lookup(NbMavenProject.class);
                for (Profile prof : nbMavproject.getMavenProject().getActiveProfiles()) {
                    profileNames.add(prof.getId());
                }
                for (String profileId : profileNames) {
                    org.netbeans.modules.maven.model.pom.Profile modProf = this.model.getProject().findProfileById(profileId);
                    if (modProf == null || (dep = modProf.findDependencyById(eTarget.getGroupId(), eTarget.getArtifactId(), null)) == null) continue;
                    break;
                }
            }
            if (dep == null) {
                dep = this.model.getFactory().createDependency();
                dep.setGroupId(eTarget.getGroupId());
                dep.setArtifactId(eTarget.getArtifactId());
                dep.setType(eTarget.getType());
                dep.setVersion(eTarget.getVersion());
                this.model.getProject().addDependency(dep);
            }
            if ((ex = dep.findExclusionById(nodeArtif.getGroupId(), nodeArtif.getArtifactId())) != null) continue;
            ex = this.model.getFactory().createExclusion();
            ex.setGroupId(nodeArtif.getGroupId());
            ex.setArtifactId(nodeArtif.getArtifactId());
            dep.addExclusion(ex);
        }
    }

    protected void updateGraphAfterExclusion(GraphNode<MavenDependencyNode> node, Set<Artifact> exclTargets, Set<MavenDependencyNode> exclParents) {
        boolean shouldValidate = false;
        HashSet<MavenDependencyNode> toExclude = new HashSet<MavenDependencyNode>();
        block0: for (MavenDependencyNode dn : node.getDuplicatesOrConflicts()) {
            if (dn.getState() != 2) continue;
            for (MavenDependencyNode curDn = dn.getParent(); curDn != null; curDn = curDn.getParent()) {
                if (!exclTargets.contains(curDn.getArtifact())) continue;
                toExclude.add(dn);
                continue block0;
            }
        }
        ArrayList<GraphEdge> edges2Exclude = new ArrayList<GraphEdge>();
        Collection incoming = this.scene.findNodeEdges(node, false, true);
        GraphNode sourceNode = null;
        boolean primaryExcluded = false;
        block2: for (GraphEdge age : incoming) {
            sourceNode = (GraphNode)this.scene.getEdgeSource((Object)age);
            if (sourceNode == null) continue;
            for (MavenDependencyNode dn : exclParents) {
                if (((MavenDependencyNode)sourceNode.getImpl()).equals(dn)) {
                    primaryExcluded = true;
                }
                if (!sourceNode.represents((GraphNodeImplementation)dn)) continue;
                edges2Exclude.add(age);
                continue block2;
            }
        }
        node.getDuplicatesOrConflicts().removeAll(toExclude);
        for (GraphEdge age : edges2Exclude) {
            this.scene.removeEdge((Object)age);
            ((MavenDependencyNode)age.getSource()).removeChild((MavenDependencyNode)age.getTarget());
            shouldValidate = true;
        }
        incoming = this.scene.findNodeEdges(node, false, true);
        if (primaryExcluded) {
            ArtifactVersion newVersion = MavenAction.findNewest(node, true);
            ((MavenDependencyNode)node.getImpl()).getArtifact().setVersion(newVersion.toString());
            for (GraphEdge age : incoming) {
                this.scene.notifyModelChanged(age);
            }
        }
        if (incoming.isEmpty()) {
            this.removeSubGraph(node);
            shouldValidate = true;
        } else {
            this.scene.notifyModelChanged(node);
        }
        if (shouldValidate) {
            this.scene.validate();
        }
    }

    private void removeSubGraph(GraphNode node) {
        if (!this.scene.isNode((Object)node)) {
            return;
        }
        Collection incoming = this.scene.findNodeEdges((Object)node, false, true);
        if (!incoming.isEmpty()) {
            return;
        }
        Collection outgoing = this.scene.findNodeEdges((Object)node, true, false);
        ArrayList<GraphNode> children = new ArrayList<GraphNode>();
        for (GraphEdge graphEdge : outgoing) {
            MavenDependencyNode dn = (MavenDependencyNode)graphEdge.getTarget();
            GraphNode childNode = this.scene.getGraphNodeRepresentant((GraphNodeImplementation)dn);
            if (childNode == null) continue;
            children.add(childNode);
            this.scene.removeEdge((Object)graphEdge);
            ((MavenDependencyNode)graphEdge.getSource()).removeChild(dn);
            childNode.getDuplicatesOrConflicts().remove(dn);
        }
        for (GraphNode graphNode : children) {
            this.removeSubGraph(graphNode);
        }
        this.scene.removeNode((Object)node);
    }

    static ArtifactVersion findNewest(GraphNode<MavenDependencyNode> node, boolean all) {
        Set conf = node.getDuplicatesOrConflicts();
        DefaultArtifactVersion result = new DefaultArtifactVersion(((MavenDependencyNode)node.getImpl()).getArtifact().getVersion());
        DefaultArtifactVersion curV = null;
        for (MavenDependencyNode dn : conf) {
            if (!all && dn.getState() != 2 || result.compareTo((Object)(curV = new DefaultArtifactVersion(dn.getArtifact().getVersion()))) >= 0) continue;
            result = curV;
        }
        return result;
    }
}

