/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui.cssprep;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorUI;
import org.netbeans.modules.web.common.ui.cssprep.CssPrepOptionsPanel;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorAccessor;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorsAccessor;
import org.netbeans.modules.web.common.ui.spi.CssPreprocessorUIImplementation;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class CssPrepOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CssPrepOptionsPanelController.class.getName());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final List<CssPreprocessorUIImplementation.Options> allOptions = new CopyOnWriteArrayList<CssPreprocessorUIImplementation.Options>();
    private volatile CssPrepOptionsPanel cssPrepOptionsPanel = null;
    private volatile boolean changed = false;

    public void update() {
        assert (EventQueue.isDispatchThread());
        for (CssPreprocessorUIImplementation.Options options : this.allOptions) {
            options.update();
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (CssPreprocessorUIImplementation.Options options : CssPrepOptionsPanelController.this.allOptions) {
                    assert (options.isValid()) : "Saving invalid options: " + options.getDisplayName() + " (error: " + options.getErrorMessage() + ")";
                    try {
                        options.save();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Error while saving CSS preprocessor: " + options.getDisplayName(), ex);
                    }
                }
                CssPrepOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        CssPrepOptionsPanel panel = this.getCssPrepOptionsPanel();
        String warning = null;
        for (CssPreprocessorUIImplementation.Options options : this.allOptions) {
            if (!options.isValid()) {
                String error = options.getErrorMessage();
                Parameters.notNull((CharSequence)"error", (Object)error);
                panel.setError(error);
                return false;
            }
            if (warning != null) continue;
            warning = options.getWarningMessage();
        }
        if (warning != null) {
            panel.setWarning(warning);
        } else {
            panel.setError(" ");
        }
        return true;
    }

    public boolean isChanged() {
        boolean isChanged = false;
        for (CssPreprocessorUIImplementation.Options options : this.allOptions) {
            isChanged |= options.changed();
        }
        return isChanged;
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getCssPrepOptionsPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.common.cssprep.CssPrepOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private CssPrepOptionsPanel getCssPrepOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.cssPrepOptionsPanel == null) {
            for (CssPreprocessorUI preprocessor : CssPreprocessorsAccessor.getDefault().getPreprocessors()) {
                CssPreprocessorUIImplementation.Options options = CssPreprocessorAccessor.getDefault().createOptions(preprocessor);
                if (options == null) continue;
                this.allOptions.add(options);
            }
            this.cssPrepOptionsPanel = new CssPrepOptionsPanel(new ArrayList<CssPreprocessorUIImplementation.Options>(this.allOptions));
            for (CssPreprocessorUIImplementation.Options options : this.allOptions) {
                options.addChangeListener(this);
            }
        }
        return this.cssPrepOptionsPanel;
    }
}

