/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.CancelSupportImplementation;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.SchedulerTaskCancelSupportImpl;
import org.netbeans.modules.csl.core.SpiSupportAccessor;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public final class SuggestionsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SuggestionsTask.class.getName());
    private final CancelSupportImplementation cancel = SchedulerTaskCancelSupportImpl.create((SchedulerTask)this);
    private volatile HintsProvider pendingProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ParserResult result, SchedulerEvent event) {
        FileObject fileObject = result.getSnapshot().getSource().getFileObject();
        if (fileObject == null || this.cancel.isCancelled()) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent) || this.cancel.isCancelled()) {
            return;
        }
        SpiSupportAccessor.getInstance().setCancelSupport(this.cancel);
        try {
            CursorMovedSchedulerEvent evt = (CursorMovedSchedulerEvent)event;
            int[] range = new int[]{Math.min(evt.getMarkOffset(), evt.getCaretOffset()), Math.max(evt.getMarkOffset(), evt.getCaretOffset())};
            if (range != null && range.length == 2 && range[0] != -1 && range[1] != -1 && range[0] != range[1]) {
                HintsController.setErrors((FileObject)fileObject, (String)SuggestionsTask.class.getName(), Collections.emptyList());
                return;
            }
            final int pos = evt.getCaretOffset();
            if (pos == -1 || this.cancel.isCancelled()) {
                return;
            }
            try {
                ParserManager.parse(Collections.singleton(result.getSnapshot().getSource()), (UserTask)new UserTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result r = resultIterator.getParserResult(pos);
                        if (!(r instanceof ParserResult)) {
                            return;
                        }
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(r.getSnapshot().getMimeType());
                        if (language == null) return;
                        if (SuggestionsTask.this.cancel.isCancelled()) {
                            return;
                        }
                        HintsProvider provider = language.getHintsProvider();
                        if (provider == null) return;
                        if (SuggestionsTask.this.cancel.isCancelled()) {
                            return;
                        }
                        GsfHintsManager manager = language.getHintsManager();
                        if (manager == null) return;
                        if (SuggestionsTask.this.cancel.isCancelled()) {
                            return;
                        }
                        RuleContext ruleContext = manager.createRuleContext((ParserResult)r, language, pos, -1, -1);
                        if (ruleContext == null) return;
                        if (SuggestionsTask.this.cancel.isCancelled()) {
                            return;
                        }
                        ArrayList<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
                        ArrayList<Hint> hints = new ArrayList<Hint>();
                        OffsetRange linerange = SuggestionsTask.findLineBoundaries(resultIterator.getSnapshot().getText(), pos);
                        try {
                            1 var10_10 = this;
                            synchronized (var10_10) {
                                SuggestionsTask.this.pendingProvider = provider;
                                if (SuggestionsTask.this.cancel.isCancelled()) {
                                    return;
                                }
                            }
                            provider.computeSuggestions(manager, ruleContext, hints, pos);
                        }
                        finally {
                            SuggestionsTask.this.pendingProvider = null;
                        }
                        for (int i = 0; i < hints.size(); ++i) {
                            Hint hint = (Hint)hints.get(i);
                            assert (hint != null) : provider.getClass().getName();
                            if (SuggestionsTask.this.cancel.isCancelled()) {
                                return;
                            }
                            if (linerange != OffsetRange.NONE && !SuggestionsTask.overlaps(linerange, hint.getRange())) continue;
                            ErrorDescription desc = manager.createDescription(hint, ruleContext, false, i == hints.size() - 1);
                            descriptions.add(desc);
                        }
                        if (SuggestionsTask.this.cancel.isCancelled()) {
                            return;
                        }
                        HintsController.setErrors((FileObject)r.getSnapshot().getSource().getFileObject(), (String)SuggestionsTask.class.getName(), descriptions);
                    }
                });
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        finally {
            SpiSupportAccessor.getInstance().removeCancelSupport(this.cancel);
        }
    }

    private static boolean overlaps(OffsetRange line, OffsetRange hint) {
        return hint.overlaps(line) || hint.isEmpty() && line.containsInclusive(hint.getStart());
    }

    private static OffsetRange findLineBoundaries(CharSequence s, int position) {
        int max;
        int min;
        int l = s.length();
        if (position == -1 || position > l) {
            return OffsetRange.NONE;
        }
        if (position == l && l >= 1 && s.charAt(l - 1) == '\n') {
            return new OffsetRange(l - 1, l);
        }
        for (min = position; min > 1 && s.charAt(min - 1) != '\n'; --min) {
        }
        for (max = position; max < l && s.charAt(max) != '\n'; ++max) {
        }
        return new OffsetRange(min, max);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        HintsProvider p = this.pendingProvider;
        if (p != null) {
            p.cancel();
        }
    }
}

