/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class PHP81UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP81UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP81UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            TokenSequence ts = phpParseResult.getSnapshot().getTokenHierarchy().tokenSequence(PHPTokenId.language());
            assert (ts != null);
            errors.addAll(checkVisitor.getErrors((TokenSequence<PHPTokenId>)ts));
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_81);
    }

    private static final class PHP81VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.81";

        private PHP81VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP81VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP81VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors(TokenSequence<PHPTokenId> ts) {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkConstantDeclaration(node);
            super.visit(node);
        }

        @Override
        public void visit(IntersectionType node) {
            this.createError(node);
            super.visit(node);
        }

        private void checkConstantDeclaration(ConstantDeclaration constantDeclaration) {
            if (BodyDeclaration.Modifier.isFinal(constantDeclaration.getModifier())) {
                for (Identifier name : constantDeclaration.getNames()) {
                    this.createError(name);
                }
            }
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP81VersionError(this.fileObject, startOffset, endOffset));
        }
    }
}

