/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.util.HashSet;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class AnnotatedNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    private static final RequestProcessor RP = new RequestProcessor(AnnotatedNode.class.getName());
    private Set<FileObject> files;
    private Set<FileStatusListener> fileSystemListeners;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private boolean forceAnnotation;

    protected AnnotatedNode(Children children) {
        super(children, null);
    }

    protected AnnotatedNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    protected final void setFiles(Set<FileObject> files) {
        this.fileSystemListeners = new HashSet<FileStatusListener>();
        this.files = files;
        if (files == null) {
            return;
        }
        HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
        for (FileObject fo : files) {
            try {
                FileSystem fs = fo.getFileSystem();
                if (hookedFileSystems.contains(fs)) continue;
                hookedFileSystems.add(fs);
                FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                fs.addFileStatusListener(fsl);
                this.fileSystemListeners.add(fsl);
            }
            catch (FileStateInvalidException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "Cannot get " + fo + " filesystem, ignoring...");
                err.notify(1, (Throwable)e);
            }
        }
    }

    protected final Set<FileObject> getFiles() {
        return this.files;
    }

    protected void setForceAnnotation(boolean forceAnnotation) {
        this.forceAnnotation = forceAnnotation;
    }

    protected final Image annotateIcon(Image img, int type) {
        Image annotatedImg = img;
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fo = this.files.iterator().next();
                annotatedImg = FileUIUtils.getImageDecorator((FileSystem)fo.getFileSystem()).annotateIcon(img, type, this.files);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return annotatedImg;
    }

    protected final String annotateName(String name) {
        String annotatedName = name;
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fo = this.files.iterator().next();
                annotatedName = fo.getFileSystem().getDecorator().annotateName(name, this.files);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return annotatedName;
    }

    public final void annotationChanged(FileStatusEvent event) {
        if (this.task == null) {
            this.task = RP.create((Runnable)this);
        }
        boolean changed = false;
        if (this.forceAnnotation || !this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
            for (FileObject fo : this.files) {
                if (!event.hasChanged(fo)) continue;
                this.iconChange |= event.isIconChange();
                this.nameChange |= event.isNameChange();
                changed = true;
            }
        }
        if (changed) {
            this.task.schedule(50);
        }
    }

    @Override
    public final void run() {
        if (this.forceAnnotation || this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.forceAnnotation || this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }
}

