/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.output.Bundle;
import org.netbeans.modules.maven.output.CompileAnnotation;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class JavaOutputListenerProvider
implements OutputProcessor {
    private static final String[] JAVAGOALS = new String[]{"mojo-execute#compiler:compile", "mojo-execute#compiler:testCompile", "mojo-execute#takari-lifecycle-plugin:compile", "mojo-execute#takari-lifecycle-plugin:testCompile"};
    private final Pattern failPattern;
    private String windowsDrive;
    private final RunConfig config;
    private Boolean jdk9compilerVersionOK;
    private static final String GROUP_CLAZZ_NAME = "clazz";
    private static final String GROUP_LINE_NR = "linenr";
    private static final String GROUP_TEXT = "text";
    private static final String GROUP_DRIVE_NAME = "drive";
    private static final Pattern windowsDriveInfoPattern = Pattern.compile("(?:\\[INFO\\] )?Compiling \\d+ source files? to (?<drive>[A-Za-z]:)\\\\.+");
    private static final Pattern COMPILER_PROBLEM = Pattern.compile(".*module-info\\.java:.*module not found: .*");

    public JavaOutputListenerProvider(RunConfig config) {
        this.config = config;
        this.failPattern = Pattern.compile("\\s*(?:\\[(WARNING|ERROR)\\])?(?:\\[javac\\])?(?:Compilation failure)?\\s*(?<clazz>.*)\\.java\\:\\[(?<linenr>[0-9]*),([0-9]*)\\] (?<text>.*)", 32);
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.failPattern.matcher(line);
        if (match.matches()) {
            boolean isImportant;
            Sources srcs;
            Project prj;
            String clazz = match.group(GROUP_CLAZZ_NAME);
            String lineNum = match.group(GROUP_LINE_NR);
            String text = match.group(GROUP_TEXT);
            File clazzfile = clazz.startsWith("\\") && !clazz.startsWith("\\\\") && this.windowsDrive != null ? FileUtil.normalizeFile((File)new File(this.windowsDrive + clazz + ".java")) : FileUtil.normalizeFile((File)new File(clazz + ".java"));
            FileUtil.refreshFor((File[])new File[]{clazzfile});
            FileObject file = FileUtil.toFileObject((File)clazzfile);
            String newclazz = clazz;
            if (file != null && (prj = FileOwnerQuery.getOwner((FileObject)file)) != null && (srcs = (Sources)prj.getLookup().lookup(Sources.class)) != null) {
                for (SourceGroup grp : srcs.getSourceGroups("java")) {
                    if (!FileUtil.isParentOf((FileObject)grp.getRootFolder(), (FileObject)file) || !(newclazz = FileUtil.getRelativePath((FileObject)grp.getRootFolder(), (FileObject)file)).endsWith(".java")) continue;
                    newclazz = newclazz.substring(0, newclazz.length() - ".java".length());
                }
            }
            line = line.replace(clazz, newclazz);
            boolean bl = isImportant = text.indexOf("[deprecation]") < 0;
            if (COMPILER_PROBLEM.matcher(line).matches() && !this.isJDK9CompilerVersion().booleanValue()) {
                visitor.setLine(line + "\n" + Bundle.TXT_ModulesNotSupported());
                visitor.setOutputListener(new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        FileObject pomFO = FileUtil.toFileObject((File)JavaOutputListenerProvider.this.config.getMavenProject().getFile());
                        ModelSource modelSource = Utilities.createModelSource((FileObject)pomFO);
                        POMModel model = POMModelFactory.getDefault().getModel(modelSource);
                        org.netbeans.modules.maven.model.pom.Project p = model.getProject();
                        Build bld = p.getBuild();
                        if (bld != null) {
                            Plugin plg = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
                            if (plg != null) {
                                int pos = plg.findPosition();
                                if (pos > -1) {
                                    Utilities.openAtPosition((POMModel)model, (int)pos);
                                } else {
                                    this.open(pomFO);
                                }
                            }
                        } else {
                            this.open(pomFO);
                        }
                    }

                    private void open(FileObject pomFO) {
                        try {
                            DataObject pomDO = DataObject.find((FileObject)pomFO);
                            OpenCookie oc = (OpenCookie)pomDO.getLookup().lookup(OpenCookie.class);
                            if (oc != null) {
                                oc.open();
                            }
                        }
                        catch (DataObjectNotFoundException x) {
                            Logger.getLogger(JavaOutputListenerProvider.class.getName()).log(Level.INFO, null, x);
                        }
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }, false);
            } else {
                visitor.setLine(line);
                visitor.setOutputListener(new CompileAnnotation(clazzfile, lineNum, text), isImportant);
            }
        }
        if ((match = windowsDriveInfoPattern.matcher(line)).matches()) {
            this.windowsDrive = match.group(GROUP_DRIVE_NAME);
        }
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return JAVAGOALS;
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private synchronized Boolean isJDK9CompilerVersion() {
        if (this.jdk9compilerVersionOK == null) {
            String version = PluginPropertyUtils.getPluginVersion(this.config.getMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
            this.jdk9compilerVersionOK = new ComparableVersion(version).compareTo(new ComparableVersion("3.6-SNAPSHOT")) >= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.jdk9compilerVersionOK;
    }
}

