/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.output;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.output.Bundle;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputUtils {
    public static final Pattern linePattern = Pattern.compile("(?:\\[catch\\])?\\sat (.*)\\((?:Native Method|(.*)\\.java\\:(\\d+))\\)");
    private static final Map<Project, StacktraceOutputListener> projectStacktraceListeners = new WeakHashMap<Project, StacktraceOutputListener>();
    private static final Map<FileObject, StacktraceOutputListener> fileStacktraceListeners = new WeakHashMap<FileObject, StacktraceOutputListener>();

    private OutputUtils() {
    }

    @Deprecated
    public static OutputListener matchStackTraceLine(String line, ClassPath classPath) {
        StacktraceAttributes sa = OutputUtils.matchStackTraceLine(line);
        return sa != null ? new ClassPathStacktraceOutputListener(classPath, sa) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputListener matchStackTraceLine(String line, Project project) {
        StacktraceAttributes sa = OutputUtils.matchStackTraceLine(line);
        if (sa != null) {
            Map<Project, StacktraceOutputListener> map = projectStacktraceListeners;
            synchronized (map) {
                StacktraceOutputListener list = projectStacktraceListeners.get(project);
                if (list == null) {
                    list = new ProjectStacktraceOutputListener(project);
                    projectStacktraceListeners.put(project, list);
                }
                return list;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputListener matchStackTraceLine(String line, FileObject fileObject) {
        StacktraceAttributes sa = OutputUtils.matchStackTraceLine(line);
        if (sa != null) {
            Map<FileObject, StacktraceOutputListener> map = fileStacktraceListeners;
            synchronized (map) {
                StacktraceOutputListener list = fileStacktraceListeners.get(fileObject);
                if (list == null) {
                    list = new FileObjectStacktraceOutputListener(fileObject);
                    fileStacktraceListeners.put(fileObject, list);
                }
                return list;
            }
        }
        return null;
    }

    private static StacktraceAttributes matchStackTraceLine(String line) {
        Matcher match = linePattern.matcher(line);
        if (match.matches() && match.groupCount() == 3) {
            int index;
            String method = match.group(1);
            String file = match.group(2);
            String lineNum = match.group(3);
            int n = index = file == null || file.isEmpty() ? -1 : method.indexOf(file);
            if (index > -1) {
                return new StacktraceAttributes(method, file, lineNum);
            }
        }
        return null;
    }

    private static class ClassPathStacktraceOutputListener
    extends StacktraceOutputListener {
        private final ClassPath classPath;
        private final StacktraceAttributes sa;

        public ClassPathStacktraceOutputListener(ClassPath classPath, StacktraceAttributes sa) {
            this.classPath = classPath;
            this.sa = sa;
        }

        @Override
        protected ClassPath getClassPath() {
            return this.classPath;
        }

        @Override
        protected StacktraceAttributes getStacktraceAttributes(String line) {
            return this.sa;
        }
    }

    private static class FileObjectStacktraceOutputListener
    extends StacktraceOutputListener {
        private final WeakReference<FileObject> ref;

        public FileObjectStacktraceOutputListener(FileObject file) {
            this.ref = new WeakReference<FileObject>(file);
        }

        @Override
        protected ClassPath getClassPath() {
            FileObject fileObject = (FileObject)this.ref.get();
            if (fileObject != null) {
                return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            }
            return null;
        }
    }

    private static class ProjectStacktraceOutputListener
    extends StacktraceOutputListener {
        private final WeakReference<Project> ref;

        public ProjectStacktraceOutputListener(Project project) {
            this.ref = new WeakReference<Project>(project);
        }

        @Override
        protected ClassPath getClassPath() {
            Project prj = (Project)this.ref.get();
            if (prj != null) {
                ClassPath[] cp = ((ProjectSourcesClassPathProvider)prj.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPaths("classpath/execute");
                return ClassPathSupport.createProxyClassPath((ClassPath[])cp);
            }
            return null;
        }
    }

    private static abstract class StacktraceOutputListener
    implements OutputListener {
        private StacktraceOutputListener() {
        }

        protected abstract ClassPath getClassPath();

        protected StacktraceAttributes getStacktraceAttributes(String line) {
            return OutputUtils.matchStackTraceLine(line);
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            StacktraceAttributes sa = OutputUtils.matchStackTraceLine(ev.getLine());
            if (sa == null || sa.method == null || sa.file == null) {
                Logger.getLogger(OutputUtils.class.getName()).log(Level.WARNING, "No file found for output line {0}", ev.getLine());
                StatusDisplayer.getDefault().setStatusText(Bundle.NoSource(ev.getLine()));
                return;
            }
            ClassPath classPath = this.getClassPath();
            int index = sa.method.indexOf(sa.file);
            String packageName = sa.method.substring(0, index).replace('.', '/');
            String resourceName = packageName + sa.file + ".class";
            List resources = classPath.findAllResources(resourceName);
            if (resources != null) {
                for (FileObject resource : resources) {
                    FileObject root = classPath.findOwnerRoot(resource);
                    if (root == null) continue;
                    URL url = URLMapper.findURL((FileObject)root, (int)0);
                    SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)url);
                    FileObject[] rootz = res.getRoots();
                    for (int i = 0; i < rootz.length; ++i) {
                        String path = packageName + sa.file + ".java";
                        FileObject javaFo = rootz[i].getFileObject(path);
                        if (javaFo == null) continue;
                        try {
                            DataObject obj = DataObject.find((FileObject)javaFo);
                            EditorCookie cookie = (EditorCookie)obj.getLookup().lookup(EditorCookie.class);
                            if (cookie != null) {
                                int lineInt = Integer.parseInt(sa.lineNum);
                                try {
                                    cookie.getLineSet().getCurrent(lineInt - 1).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                                }
                                catch (IndexOutOfBoundsException x) {
                                    cookie.open();
                                }
                            } else {
                                Logger.getLogger(OutputUtils.class.getName()).log(Level.WARNING, "No cookie found for dataobject {0}", obj);
                            }
                            return;
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                StatusDisplayer.getDefault().setStatusText(Bundle.NoSource(sa.file));
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.NotFound(sa.file));
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class StacktraceAttributes {
        private final String method;
        private final String file;
        private final String lineNum;

        public StacktraceAttributes(String method, String file, String lineNum) {
            this.method = method;
            this.file = file;
            this.lineNum = lineNum;
        }
    }
}

