/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ejbcore.action.AbstractMethodGenerator;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.openide.filesystems.FileObject;

public final class CmFieldGenerator
extends AbstractMethodGenerator {
    static final Set<Modifier> PUBLIC_ABSTRACT = new HashSet<Modifier>(Arrays.asList(Modifier.PUBLIC, Modifier.ABSTRACT));

    private CmFieldGenerator(String ejbClass, FileObject ejbClassFileObject) {
        super(ejbClass, ejbClassFileObject);
    }

    public static CmFieldGenerator create(String ejbClass, FileObject ejbClassFileObject) {
        return new CmFieldGenerator(ejbClass, ejbClassFileObject);
    }

    public void addCmpField(MethodModel.Variable field, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, String description) throws IOException {
        EjbJar ejbJar = DDProvider.getDefault().getDDRoot(this.ejbModule.getDeploymentDescriptor());
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        Entity entity = (Entity)enterpriseBeans.findBeanByName("Entity", "EjbClass", this.ejbClass);
        if (!CmFieldGenerator.containsField(this.ejbClassFileObject, entity.getEjbClass(), field)) {
            this.addFieldToClass(field, localGetter, localSetter, remoteGetter, remoteSetter);
        }
        if (!CmFieldGenerator.containsField(entity, field)) {
            CmpField cmpField = entity.newCmpField();
            cmpField.setFieldName(field.getName());
            cmpField.setDescription(description);
            entity.addCmpField(cmpField);
            this.saveXml();
        }
    }

    public void addFieldToClass(final MethodModel.Variable variable, final boolean localGetter, final boolean localSetter, final boolean remoteGetter, final boolean remoteSetter) throws IOException {
        JavaSource javaSource;
        Task<WorkingCopy> ejbClassTask = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(CmFieldGenerator.this.ejbClass);
                MethodTree getterTree = CmFieldGenerator.createGetter(workingCopy, variable, PUBLIC_ABSTRACT);
                MethodTree setterTree = CmFieldGenerator.createSetter(workingCopy, variable, PUBLIC_ABSTRACT);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)getterTree);
                newClassTree = workingCopy.getTreeMaker().addClassMember(newClassTree, (Tree)setterTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        };
        Map<String, String> interfaces = this.getInterfaces();
        final String local = interfaces.get("Local");
        final String remote = interfaces.get("Remote");
        if (localGetter || localSetter) {
            FileObject localFileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, local);
            javaSource = JavaSource.forFileObject((FileObject)localFileObject);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(local);
                    ClassTree newClassTree = classTree = workingCopy.getTrees().getTree(typeElement);
                    if (localGetter) {
                        MethodTree getterTree = CmFieldGenerator.createGetter(workingCopy, variable, Collections.emptySet());
                        newClassTree = workingCopy.getTreeMaker().addClassMember(newClassTree, (Tree)getterTree);
                    }
                    if (localSetter) {
                        MethodTree setterTree = CmFieldGenerator.createSetter(workingCopy, variable, Collections.emptySet());
                        newClassTree = workingCopy.getTreeMaker().addClassMember(newClassTree, (Tree)setterTree);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
                }
            }).commit();
        }
        if (remoteGetter || remoteSetter) {
            FileObject remoteFileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, remote);
            javaSource = JavaSource.forFileObject((FileObject)remoteFileObject);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(remote);
                    ClassTree newClassTree = classTree = workingCopy.getTrees().getTree(typeElement);
                    if (remoteGetter) {
                        MethodTree getterTree = CmFieldGenerator.createGetter(workingCopy, variable, Collections.emptySet());
                        newClassTree = workingCopy.getTreeMaker().addClassMember(newClassTree, (Tree)getterTree);
                    }
                    if (remoteSetter) {
                        MethodTree setterTree = CmFieldGenerator.createSetter(workingCopy, variable, Collections.emptySet());
                        newClassTree = workingCopy.getTreeMaker().addClassMember(newClassTree, (Tree)setterTree);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
                }
            }).commit();
        }
        JavaSource javaSource2 = JavaSource.forFileObject((FileObject)this.ejbClassFileObject);
        javaSource2.runModificationTask((Task)ejbClassTask).commit();
    }

    private static boolean containsField(FileObject fileObject, final String className, final MethodModel.Variable field) throws IOException {
        final boolean[] result = new boolean[]{false};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                String getterName = "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    if (!method.getSimpleName().contentEquals(getterName)) continue;
                    result[0] = true;
                    return;
                }
            }
        }, true);
        return result[0];
    }

    private static boolean containsField(Entity entity, MethodModel.Variable field) {
        for (CmpField cmpField : entity.getCmpField()) {
            if (!cmpField.getFieldName().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static MethodTree createGetter(WorkingCopy workingCopy, MethodModel.Variable field, Set<Modifier> modifiers) {
        MethodModel methodModel = MethodModel.create((String)("get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1)), (String)field.getType(), null, Collections.emptyList(), Collections.emptyList(), modifiers);
        return MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
    }

    private static MethodTree createSetter(WorkingCopy workingCopy, MethodModel.Variable field, Set<Modifier> modifiers) {
        MethodModel methodModel = MethodModel.create((String)("set" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1)), (String)"void", null, Collections.singletonList(MethodModel.Variable.create((String)field.getType(), (String)field.getName())), Collections.emptyList(), modifiers);
        return MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
    }
}

