/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.TypeUsage;

public class JsObjectReference
extends JsObjectImpl
implements JsReference {
    private final JsObject original;
    private final Set<Modifier> modifiers;

    public JsObjectReference(JsObject parent, Identifier declarationName, @NonNull JsObject original, boolean isDeclared, Set<Modifier> modifiers) {
        super(parent, declarationName, declarationName.getOffsetRange(), isDeclared, modifiers == null ? EnumSet.noneOf(Modifier.class) : modifiers, original.getMimeType(), original.getSourceLabel());
        this.original = original;
        this.modifiers = modifiers;
    }

    @Override
    public Map<String, ? extends JsObject> getProperties() {
        return this.original.getProperties();
    }

    @Override
    public void addProperty(String name, JsObject property) {
        this.original.addProperty(name, property);
    }

    @Override
    public JsObject getProperty(String name) {
        return this.original.getProperty(name);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public JsElement.Kind getJSKind() {
        JsElement.Kind kind = this.original.getJSKind();
        if (kind == JsElement.Kind.ANONYMOUS_OBJECT) {
            kind = JsElement.Kind.OBJECT_LITERAL;
        }
        return kind;
    }

    @Override
    public ElementKind getKind() {
        return this.original.getKind();
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers != null) {
            return this.modifiers;
        }
        return this.original.getModifiers();
    }

    @Override
    public JsObject getOriginal() {
        return this.original;
    }

    @Override
    public Collection<? extends TypeUsage> getAssignmentForOffset(int offset) {
        return this.original.getAssignmentForOffset(offset);
    }

    @Override
    public Collection<? extends TypeUsage> getAssignments() {
        return this.original.getAssignments();
    }

    @Override
    public void resolveTypes(JsDocumentationHolder docHolder) {
    }

    @Override
    public Documentation getDocumentation() {
        return this.original.getDocumentation();
    }

    @Override
    protected void correctTypes(String fromType, String toType) {
    }
}

