/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.build.ui.Bundle;
import org.netbeans.modules.web.clientproject.spi.build.CustomizerPanelImplementation;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CustomizerPanel
extends JPanel
implements ChangeListener {
    private final ProjectCustomizer.Category category;
    private final BuildTools.CustomizerSupport customizerSupport;
    @NullAllowed
    private final CustomizerPanelImplementation customizerPanel;
    private final List<BuildTask> buildTasks = new CopyOnWriteArrayList<BuildTask>();
    private JLabel assignLabel;
    private JCheckBox buildCheckBox;
    private JTextField buildTextField;
    private JCheckBox cleanCheckBox;
    private JTextField cleanTextField;
    private JCheckBox debugFileCheckBox;
    private JTextField debugFileTextField;
    private JCheckBox debugProjectCheckBox;
    private JTextField debugProjectTextField;
    private JPanel extenderPanel;
    private JCheckBox rebuildCheckBox;
    private JTextField rebuildTextField;
    private JCheckBox runFileCheckBox;
    private JTextField runFileTextField;
    private JCheckBox runProjectCheckBox;
    private JTextField runProjectTextField;
    private JCheckBox testFileCheckBox;
    private JTextField testFileTextField;
    private JCheckBox testProjectCheckBox;
    private JTextField testProjectTextField;

    public CustomizerPanel(BuildTools.CustomizerSupport customizerSupport) {
        assert (EventQueue.isDispatchThread());
        assert (customizerSupport != null);
        this.customizerSupport = customizerSupport;
        this.category = customizerSupport.getCategory();
        this.customizerPanel = customizerSupport.getCustomizerPanel();
        this.initComponents();
        this.init();
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="It is SPI, so no real control over the returned value")
    private void init() {
        this.assignLabel.setText(this.customizerSupport.getHeader());
        this.buildTasks.add(new BuildTask("build", "build", this.buildCheckBox, this.buildTextField));
        this.buildTasks.add(new BuildTask("clean", "clean", this.cleanCheckBox, this.cleanTextField));
        this.buildTasks.add(new BuildTask("rebuild", "clean build", this.rebuildCheckBox, this.rebuildTextField));
        this.buildTasks.add(new BuildTask("run", "run", this.runProjectCheckBox, this.runProjectTextField));
        this.buildTasks.add(new BuildTask("debug", "debug", this.debugProjectCheckBox, this.debugProjectTextField));
        this.buildTasks.add(new BuildTask("test", "test", this.testProjectCheckBox, this.testProjectTextField));
        this.buildTasks.add(new BuildTask("run.single", "runfile", this.runFileCheckBox, this.runFileTextField));
        this.buildTasks.add(new BuildTask("debug.single", "debugfile", this.debugFileCheckBox, this.debugFileTextField));
        this.buildTasks.add(new BuildTask("test.single", "testfile", this.testFileCheckBox, this.testFileTextField));
        for (BuildTask buildTask : this.buildTasks) {
            buildTask.setText(this.customizerSupport.getTask(buildTask.getCommandId()));
        }
        if (this.customizerPanel != null) {
            JComponent component = this.customizerPanel.getComponent();
            assert (component != null) : "Non-null component must be returned for panel of " + this.category.getDisplayName();
            this.extenderPanel.add((Component)component, "Center");
            this.extenderPanel.revalidate();
            this.extenderPanel.repaint();
        }
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerPanel.this.saveData();
            }
        });
        if (this.customizerPanel != null) {
            this.customizerPanel.addChangeListener(this);
        }
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        for (BuildTask buildTask : this.buildTasks) {
            String text = buildTask.getText();
            if (text == null || !text.isEmpty()) continue;
            this.category.setErrorMessage(Bundle.CustomizerPanel_error_field_empty());
            this.category.setValid(false);
            return;
        }
        String message = " ";
        if (this.customizerPanel != null) {
            if (!this.customizerPanel.isValid()) {
                String error = this.customizerPanel.getErrorMessage();
                assert (error != null) : "Non-null error message must be returned for invalid panel of " + this.category.getDisplayName();
                this.category.setErrorMessage(error);
                this.category.setValid(false);
                return;
            }
            String warning = this.customizerPanel.getWarningMessage();
            if (warning != null) {
                message = warning;
            }
        }
        this.category.setErrorMessage(message);
        this.category.setValid(true);
    }

    void saveData() {
        assert (!EventQueue.isDispatchThread());
        for (BuildTask buildTask : this.buildTasks) {
            this.customizerSupport.setTask(buildTask.getCommandId(), buildTask.getText());
        }
        if (this.customizerPanel != null) {
            this.customizerPanel.save();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateData();
    }

    private void initComponents() {
        this.assignLabel = new JLabel();
        this.buildCheckBox = new JCheckBox();
        this.buildTextField = new JTextField();
        this.cleanCheckBox = new JCheckBox();
        this.cleanTextField = new JTextField();
        this.rebuildCheckBox = new JCheckBox();
        this.rebuildTextField = new JTextField();
        this.runProjectCheckBox = new JCheckBox();
        this.runProjectTextField = new JTextField();
        this.debugProjectCheckBox = new JCheckBox();
        this.debugProjectTextField = new JTextField();
        this.testProjectCheckBox = new JCheckBox();
        this.testProjectTextField = new JTextField();
        this.runFileCheckBox = new JCheckBox();
        this.runFileTextField = new JTextField();
        this.debugFileCheckBox = new JCheckBox();
        this.debugFileTextField = new JTextField();
        this.testFileCheckBox = new JCheckBox();
        this.testFileTextField = new JTextField();
        this.extenderPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.assignLabel, (String)"TITLE");
        Mnemonics.setLocalizedText((AbstractButton)this.buildCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.buildCheckBox.text"));
        this.buildTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.cleanCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.cleanCheckBox.text"));
        this.cleanTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.rebuildCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.rebuildCheckBox.text"));
        this.rebuildTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.runProjectCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.runProjectCheckBox.text"));
        this.runProjectTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.debugProjectCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.debugProjectCheckBox.text"));
        this.debugProjectTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.testProjectCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.testProjectCheckBox.text"));
        this.testProjectTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.runFileCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.runFileCheckBox.text"));
        this.runFileTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.debugFileCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.debugFileCheckBox.text"));
        this.debugFileTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.testFileCheckBox, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"CustomizerPanel.testFileCheckBox.text"));
        this.testFileTextField.setColumns(20);
        this.extenderPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cleanCheckBox).addComponent(this.rebuildCheckBox).addComponent(this.buildCheckBox).addComponent(this.runProjectCheckBox).addComponent(this.debugProjectCheckBox).addComponent(this.testProjectCheckBox).addComponent(this.runFileCheckBox).addComponent(this.debugFileCheckBox).addComponent(this.testFileCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runFileTextField, GroupLayout.Alignment.TRAILING).addComponent(this.rebuildTextField, GroupLayout.Alignment.TRAILING).addComponent(this.cleanTextField, GroupLayout.Alignment.TRAILING).addComponent(this.buildTextField, GroupLayout.Alignment.TRAILING).addComponent(this.runProjectTextField, GroupLayout.Alignment.TRAILING).addComponent(this.debugProjectTextField, GroupLayout.Alignment.TRAILING).addComponent(this.testProjectTextField).addComponent(this.debugFileTextField, GroupLayout.Alignment.TRAILING).addComponent(this.testFileTextField, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.assignLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.extenderPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.assignLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildCheckBox).addComponent(this.buildTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cleanCheckBox).addComponent(this.cleanTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rebuildCheckBox).addComponent(this.rebuildTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runProjectCheckBox).addComponent(this.runProjectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugProjectCheckBox).addComponent(this.debugProjectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testProjectCheckBox).addComponent(this.testProjectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runFileCheckBox).addComponent(this.runFileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugFileCheckBox).addComponent(this.debugFileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFileCheckBox).addComponent(this.testFileTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.extenderPanel, -1, -1, Short.MAX_VALUE)));
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            CustomizerPanel.this.validateData();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private final JTextField textField;

        public DefaultItemListener(JTextField textField) {
            assert (textField != null);
            this.textField = textField;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.textField.setEnabled(e.getStateChange() == 1);
            CustomizerPanel.this.validateData();
        }
    }

    private final class BuildTask {
        private final String commandId;
        private final String defaultValue;
        private final JCheckBox checkBox;
        private final JTextField textField;

        BuildTask(String commandId, String defaultValue, JCheckBox checkBox, JTextField textField) {
            assert (commandId != null);
            assert (defaultValue != null);
            assert (checkBox != null);
            assert (textField != null);
            this.commandId = commandId;
            this.defaultValue = defaultValue;
            this.checkBox = checkBox;
            this.textField = textField;
            this.init();
        }

        private void init() {
            this.checkBox.addItemListener(new DefaultItemListener(this.textField));
            this.textField.getDocument().addDocumentListener(new DefaultDocumentListener());
        }

        public String getCommandId() {
            return this.commandId;
        }

        @CheckForNull
        public String getText() {
            if (!this.checkBox.isSelected()) {
                return null;
            }
            return this.textField.getText().trim();
        }

        public void setText(@NullAllowed String text) {
            boolean hasText = text != null;
            this.checkBox.setSelected(hasText);
            this.textField.setText(hasText ? text : this.defaultValue);
            this.textField.setEnabled(hasText);
        }
    }
}

