/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.SetPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSetObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class JSSet
extends JSNonProxy
implements JSConstructorFactory.Default.WithSpecies,
PrototypeSupplier {
    public static final JSSet INSTANCE = new JSSet();
    public static final String CLASS_NAME = "Set";
    public static final String PROTOTYPE_NAME = "Set.prototype";
    public static final String ITERATOR_CLASS_NAME = "Set Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Set Iterator.prototype";
    private static final String SIZE = "size";
    public static final HiddenKey SET_ITERATION_KIND_ID = new HiddenKey("SetIterationKind");

    private JSSet() {
    }

    public static DynamicObject create(JSContext context) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getSetFactory();
        JSSetObject obj = factory.initProto(new JSSetObject(factory.getShape(realm), new JSHashMap()), realm);
        assert (JSSet.isJSSet((Object)obj));
        return context.trackAllocation(obj);
    }

    public static Object normalize(Object value) {
        if (value instanceof Double) {
            return JSSet.normalizeDouble((Double)value);
        }
        if (value instanceof JSLazyString) {
            return ((JSLazyString)value).toString();
        }
        return value;
    }

    public static Object normalizeDouble(double value) {
        if (JSRuntime.isNegativeZero(value)) {
            return 0;
        }
        if (JSRuntime.doubleIsRepresentableAsInt(value)) {
            return (int)value;
        }
        return value;
    }

    public static JSHashMap getInternalSet(DynamicObject obj) {
        assert (JSSet.isJSSet(obj));
        return ((JSSetObject)obj).getMap();
    }

    public static int getSetSize(DynamicObject obj) {
        assert (JSSet.isJSSet(obj));
        return JSSet.getInternalSet(obj).size();
    }

    private static DynamicObject createSizeGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SetGetSize, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
                private final BranchProfile errorBranch = BranchProfile.create();

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSSet.isJSSet(obj)) {
                        return JSSet.getSetSize((DynamicObject)obj);
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeErrorSetExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get size");
        });
        DynamicObject sizeGetter = JSFunction.create(realm, getterData);
        return sizeGetter;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)SIZE, JSSet.createSizeGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SetPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        Object values = JSDynamicObject.getOrNull(prototype, "values");
        JSObjectUtil.putDataProperty(ctx, prototype, "keys", values, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_ITERATOR, values, JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[" + this.getClassName() + "]";
        }
        JSHashMap set = JSSet.getInternalSet(obj);
        return JSRuntime.collectionToConsoleString(obj, this.getClassName(obj), set, depth, allowSideEffects);
    }

    public static boolean isJSSet(Object obj) {
        return obj instanceof JSSetObject;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSetPrototype();
    }
}

