/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.PromiseFunctionBuiltins;
import com.oracle.truffle.js.builtins.PromisePrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSPromise
extends JSNonProxy
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "Promise";
    public static final String PROTOTYPE_NAME = "Promise.prototype";
    public static final JSPromise INSTANCE = new JSPromise();
    public static final String RESOLVE = "resolve";
    public static final String THEN = "then";
    public static final HiddenKey PROMISE_RESULT = new HiddenKey("PromiseResult");
    public static final HiddenKey PROMISE_IS_HANDLED = new HiddenKey("PromiseIsHandled");
    public static final HiddenKey PROMISE_FULFILL_REACTIONS = new HiddenKey("PromiseFulfillReactions");
    public static final HiddenKey PROMISE_REJECT_REACTIONS = new HiddenKey("PromiseRejectReactions");
    public static final HiddenKey PROMISE_ON_FINALLY = new HiddenKey("OnFinally");
    public static final HiddenKey PROMISE_FINALLY_CONSTRUCTOR = new HiddenKey("Constructor");
    public static final int PENDING = 0;
    public static final int FULFILLED = 1;
    public static final int REJECTED = 2;
    public static final int REJECTION_TRACKER_OPERATION_REJECT = 0;
    public static final int REJECTION_TRACKER_OPERATION_HANDLE = 1;
    public static final int REJECTION_TRACKER_OPERATION_REJECT_AFTER_RESOLVED = 2;
    public static final int REJECTION_TRACKER_OPERATION_RESOLVE_AFTER_RESOLVED = 3;

    private JSPromise() {
    }

    public static DynamicObject create(JSContext context) {
        return context.trackAllocation(JSPromiseObject.create(context.getRealm(), context.getPromiseFactory(), 0));
    }

    public static DynamicObject create(JSContext context, Shape shape) {
        JSPromiseObject promise = JSPromiseObject.create(shape, 0);
        assert (JSPromise.isJSPromise((Object)promise));
        return context.trackAllocation(promise);
    }

    public static DynamicObject createWithoutPrototype(JSContext context) {
        Shape shape = context.getPromiseShapePrototypeInObject();
        JSPromiseObject obj = JSPromiseObject.create(shape, 0);
        assert (JSPromise.isJSPromise((Object)obj));
        return obj;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static boolean isJSPromise(Object obj) {
        return obj instanceof JSPromiseObject;
    }

    public static boolean isRejected(DynamicObject promise) {
        return 2 == JSPromise.getPromiseState(promise);
    }

    public static boolean isPending(DynamicObject promise) {
        return 0 == JSPromise.getPromiseState(promise);
    }

    public static boolean isFulfilled(DynamicObject promise) {
        return 1 == JSPromise.getPromiseState(promise);
    }

    public static int getPromiseState(DynamicObject promise) {
        assert (JSPromise.isJSPromise(promise));
        return ((JSPromiseObject)promise).getPromiseState();
    }

    public static void setPromiseState(DynamicObject promise, int promiseState) {
        assert (JSPromise.isJSPromise(promise));
        ((JSPromiseObject)promise).setPromiseState(promiseState);
    }

    @Override
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects, JSContext context) {
        return JSRuntime.objectToConsoleString(obj, CLASS_NAME, depth, new String[]{"PromiseStatus", "PromiseValue"}, new Object[]{JSPromise.getStatus(obj), JSPromise.getValue(obj)}, allowSideEffects);
    }

    private static String getStatus(DynamicObject obj) {
        if (JSPromise.isFulfilled(obj)) {
            return "resolved";
        }
        if (JSPromise.isRejected(obj)) {
            return "rejected";
        }
        assert (JSPromise.isPending(obj));
        return "pending";
    }

    private static Object getValue(DynamicObject obj) {
        return JSDynamicObject.getOrDefault(obj, PROMISE_RESULT, (Object)Undefined.instance);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(context, prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, PromisePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, PromiseFunctionBuiltins.BUILTINS);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPromisePrototype();
    }
}

