/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ArrayElementInfoNode;
import com.oracle.truffle.js.nodes.interop.ArrayElementInfoNodeGen;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSArrayObject.class)
final class JSArrayObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSArrayObjectGen() {
    }

    static {
        LibraryExport.register(JSArrayObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSArrayObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSArrayObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSArrayObject);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSArrayObject);
            return new Cached();
        }

        @GeneratedBy(value=JSArrayObject.class)
        private static final class Uncached
        extends InteropLibrary {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSArrayObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSArrayObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value);
                }
                if (!JSGuards.isJSFastArray(arg0Value)) {
                    return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.readMember(arg1Value, this.javaScriptLanguageReference_, JSObject.getUncachedRead(), ((JavaScriptLanguage)this.javaScriptLanguageReference_.get()).bindMemberFunctions(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, KeyInfoNodeGen.getUncached(), ImportValueNodeGen.getUncached(), this.javaScriptLanguageReference_, JSObject.getUncachedWrite());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberModifiable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSObject)((Object)receiver)).removeMember(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberRemovable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropInvokeNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.hasMemberReadSideEffects(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.hasMemberWriteSideEffects(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).toDisplayString(allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSNonProxyObject)((Object)receiver)).hasMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSNonProxyObject)((Object)receiver)).getMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayObject)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayObject)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, this.javaScriptLanguageReference_, JSObject.getUncachedRead(), ExportValueNodeGen.getUncached(), this);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementReadable(arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, ArrayElementInfoNodeGen.getUncached(), ImportValueNodeGen.getUncached(), this.javaScriptLanguageReference_, JSObject.getUncachedWrite());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementModifiable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementInsertable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementRemovable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                arg0Value.removeArrayElement(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=JSArrayObject.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private ArrayElementInfoNode elementInfo;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Node.Child
            private ReadElementNode readMemberNode__readNode_;
            @CompilerDirectives.CompilationFinal
            private boolean readMemberNode__bindMemberFunctions_;
            @Node.Child
            private ExportValueNode readMemberNode__exportNode_;
            @Node.Child
            private ImportValueNode writeMemberNode__castValueNode_;
            @Node.Child
            private WriteElementNode writeMemberNode__writeNode_;
            @Node.Child
            private JSInteropInvokeNode invokeMemberNode__callNode_;
            @Node.Child
            private ExportValueNode invokeMemberNode__exportNode_;
            @Node.Child
            private ReadElementNode readArrayElementNode__readNode_;
            @Node.Child
            private ExportValueNode readArrayElementNode__exportNode_;
            @Node.Child
            private ImportValueNode writeArrayElementNode__castValueNode_;
            @Node.Child
            private WriteElementNode writeArrayElementNode__writeNode_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSArrayObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSArrayObject;
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && JSGuards.isJSFastArray(arg0Value)) {
                        return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value);
                    }
                    if ((state & 2) != 0 && !JSGuards.isJSFastArray(arg0Value)) {
                        return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersAndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersAndSpecialize(JSArrayObject arg0Value, boolean arg1Value) {
                int state = this.state_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    this.state_ = state |= 1;
                    return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value);
                }
                if (!JSGuards.isJSFastArray(arg0Value)) {
                    this.state_ = state |= 2;
                    return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).hasMembers();
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readMemberNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    return arg0Value.readMember(arg1Value, readMemberNode__languageRef__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference readMemberNode__languageRef__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    readMemberNode__languageRef__ = javaScriptLanguageReference__1;
                    this.readMemberNode__readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)readMemberNode__languageRef__.get()).getJSContext()));
                    this.readMemberNode__bindMemberFunctions_ = ((JavaScriptLanguage)readMemberNode__languageRef__.get()).bindMemberFunctions();
                    this.readMemberNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)readMemberNode__languageRef__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    return arg0Value.isMemberReadable(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberReadable(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeMemberNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    arg0Value.writeMember(arg1Value, arg2Value, this.keyInfo, this.writeMemberNode__castValueNode_, writeMemberNode__languageRef__, this.writeMemberNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference writeMemberNode__languageRef__ = null;
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.writeMemberNode__castValueNode_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    writeMemberNode__languageRef__ = javaScriptLanguageReference__1;
                    this.writeMemberNode__writeNode_ = (WriteElementNode)super.insert((Node)WriteElementNode.createCachedInterop((TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeMemberNode__languageRef__));
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeMember(arg1Value, arg2Value, this.keyInfo, this.writeMemberNode__castValueNode_, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeMemberNode__languageRef__, this.writeMemberNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return arg0Value.isMemberModifiable(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberModifiable(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    return arg0Value.isMemberInsertable(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInsertableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberInsertable(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayObject)receiver).removeMember(member);
            }

            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    return arg0Value.isMemberRemovable(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberRemovableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberRemovable(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x100) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage invokeMemberNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm invokeMemberNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.invokeMember(arg1Value, arg2Value, invokeMemberNode__language__, invokeMemberNode__realm__, this.invokeMemberNode__callNode_, this.invokeMemberNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    JSRealm invokeMemberNode__realm__ = null;
                    JavaScriptLanguage invokeMemberNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    invokeMemberNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    invokeMemberNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    this.invokeMemberNode__callNode_ = (JSInteropInvokeNode)super.insert((Node)JSInteropInvokeNode.create());
                    this.invokeMemberNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, invokeMemberNode__language__, invokeMemberNode__realm__, this.invokeMemberNode__callNode_, this.invokeMemberNode__exportNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x200) != 0) {
                    return arg0Value.isMemberInvocable(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberInvocable(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x400) != 0) {
                    return arg0Value.hasMemberReadSideEffects(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberReadSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.hasMemberReadSideEffects(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x800) != 0) {
                    return arg0Value.hasMemberWriteSideEffects(arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = (KeyInfoNode)super.insert((Node)KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.hasMemberWriteSideEffects(arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).toDisplayString(allowSideEffects);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).hasMetaObject();
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).getMetaObject();
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).getArraySize();
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x1000) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    Cached readArrayElementNode__thisLibrary__ = this;
                    return arg0Value.readArrayElement(arg1Value, readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.readArrayElementNode__exportNode_, readArrayElementNode__thisLibrary__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    Cached readArrayElementNode__thisLibrary__ = null;
                    TruffleLanguage.LanguageReference readArrayElementNode__languageRef__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    readArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.readArrayElementNode__readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)readArrayElementNode__languageRef__.get()).getJSContext()));
                    this.readArrayElementNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    readArrayElementNode__thisLibrary__ = this;
                    this.state_ = state |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readArrayElement(arg1Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.readArrayElementNode__exportNode_, readArrayElementNode__thisLibrary__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                Cached isArrayElementReadableNode__thisLibrary__ = this;
                return arg0Value.isArrayElementReadable(arg1Value, isArrayElementReadableNode__thisLibrary__);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x2000) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, this.elementInfo, this.writeArrayElementNode__castValueNode_, writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference writeArrayElementNode__languageRef__ = null;
                    if (this.elementInfo == null) {
                        this.elementInfo = (ArrayElementInfoNode)super.insert((Node)ArrayElementInfoNodeGen.create());
                    }
                    this.writeArrayElementNode__castValueNode_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    writeArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.writeArrayElementNode__writeNode_ = (WriteElementNode)super.insert((Node)WriteElementNode.createCachedInterop((TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeArrayElementNode__languageRef__));
                    this.state_ = state |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, this.elementInfo, this.writeArrayElementNode__castValueNode_, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x4000) != 0) {
                    return arg0Value.isArrayElementModifiable(arg1Value, this.elementInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.elementInfo == null) {
                        this.elementInfo = (ArrayElementInfoNode)super.insert((Node)ArrayElementInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x4000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isArrayElementModifiable(arg1Value, this.elementInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x8000) != 0) {
                    return arg0Value.isArrayElementInsertable(arg1Value, this.elementInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementInsertableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.elementInfo == null) {
                        this.elementInfo = (ArrayElementInfoNode)super.insert((Node)ArrayElementInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x8000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isArrayElementInsertable(arg1Value, this.elementInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x10000) != 0) {
                    return arg0Value.isArrayElementRemovable(arg1Value, this.elementInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementRemovableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.elementInfo == null) {
                        this.elementInfo = (ArrayElementInfoNode)super.insert((Node)ArrayElementInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x10000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isArrayElementRemovable(arg1Value, this.elementInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x20000) != 0) {
                    arg0Value.removeArrayElement(arg1Value, this.elementInfo);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.elementInfo == null) {
                        this.elementInfo = (ArrayElementInfoNode)super.insert((Node)ArrayElementInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x20000;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.removeArrayElement(arg1Value, this.elementInfo);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

