/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToArrayIndexNode.class)
public final class ToArrayIndexNodeGen
extends ToArrayIndexNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private ConvertFromStringData convertFromString_cache;
    @Node.Child
    private JSToPropertyKeyNode nonArrayIndex1_toPropertyKey_;

    private ToArrayIndexNodeGen(boolean convertToPropertyKey) {
        super(convertToPropertyKey);
    }

    @Override
    public Object execute(Object arg0Value) {
        int arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer && JSGuards.isIntArrayIndex(arg0Value_ = ((Integer)arg0Value).intValue())) {
            return ToArrayIndexNode.doInteger(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Long && JSGuards.isLongArrayIndex(arg0Value_ = ((Long)arg0Value).longValue())) {
            return ToArrayIndexNode.doLong(arg0Value_);
        }
        if ((state & 0xC) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, arg0Value)) {
            double arg0Value_2 = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, arg0Value);
            if ((state & 4) != 0 && ToArrayIndexNode.doubleIsIntIndex(arg0Value_2)) {
                return ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_2);
            }
            if ((state & 8) != 0 && ToArrayIndexNode.doubleIsUintIndex(arg0Value_2)) {
                return ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_2);
            }
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_3 = (Symbol)arg0Value;
            return ToArrayIndexNode.doSymbol(arg0Value_3);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof HiddenKey) {
            HiddenKey arg0Value_4 = (HiddenKey)arg0Value;
            return ToArrayIndexNode.doHiddenKey(arg0Value_4);
        }
        if ((state & 0xC0) != 0 && JSTypesGen.isImplicitString((state & 0x1C000) >>> 14, arg0Value)) {
            ConvertFromStringData s7_;
            String arg0Value_5 = JSTypesGen.asImplicitString((state & 0x1C000) >>> 14, arg0Value);
            if ((state & 0x40) != 0 && (s7_ = this.convertFromString_cache) != null && JSGuards.isArrayIndexLengthInRange(arg0Value_5)) {
                return ToArrayIndexNode.convertFromString(arg0Value_5, s7_.startsWithDigitBranch_, s7_.isArrayIndexBranch_, s7_.needPassStringBranch_);
            }
            if ((state & 0x80) != 0 && !JSGuards.isArrayIndexLengthInRange(arg0Value_5)) {
                return ToArrayIndexNode.convertFromStringNotInRange(arg0Value_5);
            }
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0) {
                assert (!this.convertToPropertyKey);
                if (ToArrayIndexNode.notArrayIndex(arg0Value)) {
                    return ToArrayIndexNode.doNonArrayIndex(arg0Value);
                }
            }
            if ((state & 0x200) != 0) {
                assert (this.convertToPropertyKey);
                if (ToArrayIndexNode.notArrayIndex(arg0Value)) {
                    return ToArrayIndexNode.doNonArrayIndex(arg0Value, this.nonArrayIndex1_toPropertyKey_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public long executeLong(Object arg0Value) throws UnexpectedResultException {
        int arg0Value_;
        int state = this.state_;
        if ((state & 0x3C0) != 0) {
            return JSTypesGen.expectLong(this.execute(arg0Value));
        }
        if ((state & 1) != 0 && arg0Value instanceof Integer && JSGuards.isIntArrayIndex(arg0Value_ = ((Integer)arg0Value).intValue())) {
            return ToArrayIndexNode.doInteger(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Long && JSGuards.isLongArrayIndex(arg0Value_ = ((Long)arg0Value).longValue())) {
            return ToArrayIndexNode.doLong(arg0Value_);
        }
        if ((state & 0xC) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, arg0Value)) {
            double arg0Value_2 = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, arg0Value);
            if ((state & 4) != 0 && ToArrayIndexNode.doubleIsIntIndex(arg0Value_2)) {
                return ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_2);
            }
            if ((state & 8) != 0 && ToArrayIndexNode.doubleIsUintIndex(arg0Value_2)) {
                return ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_2);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectLong(this.executeAndSpecialize(arg0Value));
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int arg0Value_;
            if (arg0Value instanceof Integer && JSGuards.isIntArrayIndex(arg0Value_ = ((Integer)arg0Value).intValue())) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Long l = ToArrayIndexNode.doInteger(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Long && JSGuards.isLongArrayIndex(arg0Value_ = ((Long)arg0Value).longValue())) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Long l = ToArrayIndexNode.doLong(arg0Value_);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_2 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                if (ToArrayIndexNode.doubleIsIntIndex(arg0Value_2)) {
                    state |= doubleCast0 << 10;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Long l = ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_2);
                    return l;
                }
                if (ToArrayIndexNode.doubleIsUintIndex(arg0Value_2)) {
                    state |= doubleCast0 << 10;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Long l = ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_2);
                    return l;
                }
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_3 = (Symbol)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Symbol arg0Value_2 = ToArrayIndexNode.doSymbol(arg0Value_3);
                return arg0Value_2;
            }
            if (arg0Value instanceof HiddenKey) {
                HiddenKey arg0Value_4 = (HiddenKey)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                HiddenKey arg0Value_2 = ToArrayIndexNode.doHiddenKey(arg0Value_4);
                return arg0Value_2;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_5 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                if (JSGuards.isArrayIndexLengthInRange(arg0Value_5)) {
                    ConvertFromStringData s7_ = new ConvertFromStringData();
                    s7_.startsWithDigitBranch_ = BranchProfile.create();
                    s7_.isArrayIndexBranch_ = BranchProfile.create();
                    s7_.needPassStringBranch_ = BranchProfile.create();
                    this.convertFromString_cache = s7_;
                    state |= stringCast0 << 14;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Object object = ToArrayIndexNode.convertFromString(arg0Value_5, s7_.startsWithDigitBranch_, s7_.isArrayIndexBranch_, s7_.needPassStringBranch_);
                    return object;
                }
                if (!JSGuards.isArrayIndexLengthInRange(arg0Value_5)) {
                    state |= stringCast0 << 14;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    Object object = ToArrayIndexNode.convertFromStringNotInRange(arg0Value_5);
                    return object;
                }
            }
            if (!this.convertToPropertyKey && ToArrayIndexNode.notArrayIndex(arg0Value)) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = ToArrayIndexNode.doNonArrayIndex(arg0Value);
                return object;
            }
            if (this.convertToPropertyKey && ToArrayIndexNode.notArrayIndex(arg0Value)) {
                this.nonArrayIndex1_toPropertyKey_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Object object = ToArrayIndexNode.doNonArrayIndex(arg0Value, this.nonArrayIndex1_toPropertyKey_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FF & (state & 0x3FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDoubleAsIntIndex";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doDoubleAsUintIndex";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doHiddenKey";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "convertFromString";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            ConvertFromStringData s7_ = this.convertFromString_cache;
            if (s7_ != null) {
                cached.add(Arrays.asList(s7_.startsWithDigitBranch_, s7_.isArrayIndexBranch_, s7_.needPassStringBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "convertFromStringNotInRange";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doNonArrayIndex";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doNonArrayIndex";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.nonArrayIndex1_toPropertyKey_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static ToArrayIndexNode create(boolean convertToPropertyKey) {
        return new ToArrayIndexNodeGen(convertToPropertyKey);
    }

    @GeneratedBy(value=ToArrayIndexNode.class)
    private static final class ConvertFromStringData {
        @CompilerDirectives.CompilationFinal
        BranchProfile startsWithDigitBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile isArrayIndexBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile needPassStringBranch_;

        ConvertFromStringData() {
        }
    }
}

