/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CachedGetPropertyNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNodeGen;
import com.oracle.truffle.js.nodes.access.JSProxyPropertySetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@ImportStatic(value={JSRuntime.class, CachedGetPropertyNode.class})
abstract class CachedSetPropertyNode
extends JavaScriptBaseNode {
    static final int MAX_DEPTH = 1;
    protected final JSContext context;
    protected final boolean strict;
    protected final boolean setOwn;
    protected final boolean superProperty;

    CachedSetPropertyNode(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        this.context = context;
        this.strict = strict;
        this.setOwn = setOwn;
        this.superProperty = superProperty;
    }

    public abstract void execute(DynamicObject var1, Object var2, Object var3, Object var4);

    static CachedSetPropertyNode create(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        return CachedSetPropertyNodeGen.create(context, strict, setOwn, superProperty);
    }

    @Specialization(guards={"cachedKey != null", "!isArrayIndex(cachedKey)", "propertyKeyEquals(cachedKey, key)"}, limit="MAX_DEPTH")
    void doCachedKey(DynamicObject target, Object key, Object value, Object receiver, @Cached(value="cachedPropertyKey(key)") Object cachedKey, @Cached(value="createSet(cachedKey)") PropertySetNode propertyNode) {
        propertyNode.setValue(target, value, receiver);
    }

    @Specialization(guards={"isArrayIndex(index)", "!isJSProxy(target)"})
    void doIntIndex(DynamicObject target, int index, Object value, Object receiver, @Cached(value="create()") JSClassProfile jsclassProfile) {
        this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
    }

    @Specialization(guards={"!isJSProxy(target)", "toArrayIndexNode.isResultArrayIndex(maybeIndex)"}, replaces={"doIntIndex"})
    void doArrayIndex(DynamicObject target, Object key, Object value, Object receiver, @Cached(value="createNoToPropertyKey()") ToArrayIndexNode toArrayIndexNode, @Bind(value="toArrayIndexNode.execute(key)") Object maybeIndex, @Cached(value="create()") JSClassProfile jsclassProfile) {
        long index = (Long)maybeIndex;
        this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
    }

    private void doArrayIndexLong(DynamicObject target, long index, Object value, Object receiver, JSClass jsclass) {
        if (this.setOwn) {
            CachedSetPropertyNode.createDataPropertyOrThrow(target, Boundaries.stringValueOf(index), value);
        } else {
            jsclass.set(target, index, value, receiver, this.strict);
        }
    }

    @Specialization(guards={"isJSProxy(target)"})
    void doProxy(DynamicObject target, Object index, Object value, Object receiver, @Cached(value="create(context, strict)") JSProxyPropertySetNode proxySet) {
        if (this.setOwn) {
            CachedSetPropertyNode.createDataPropertyOrThrow(target, proxySet.toPropertyKey(index), value);
        } else {
            proxySet.executeWithReceiverAndValue(target, receiver, value, index);
        }
    }

    @Specialization(replaces={"doCachedKey", "doArrayIndex", "doProxy"})
    @ReportPolymorphism.Megamorphic
    void doGeneric(DynamicObject target, Object key, Object value, Object receiver, @Cached(value="create()") ToArrayIndexNode toArrayIndexNode, @Cached(value="createBinaryProfile()") ConditionProfile getType, @Cached(value="create()") JSClassProfile jsclassProfile) {
        Object arrayIndex = toArrayIndexNode.execute(key);
        if (getType.profile(arrayIndex instanceof Long)) {
            long index = (Long)arrayIndex;
            this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
        } else {
            assert (JSRuntime.isPropertyKey(arrayIndex));
            if (this.setOwn) {
                CachedSetPropertyNode.createDataPropertyOrThrow(target, arrayIndex, value);
            } else {
                JSObject.setWithReceiver(target, arrayIndex, value, receiver, this.strict, jsclassProfile);
            }
        }
    }

    private static void createDataPropertyOrThrow(DynamicObject target, Object propertyKey, Object value) {
        JSObject.defineOwnProperty(target, propertyKey, PropertyDescriptor.createDataDefault(value), true);
    }

    PropertySetNode createSet(Object key) {
        return PropertySetNode.createImpl(key, false, this.context, this.strict, this.setOwn, JSAttributes.getDefault(), false, this.superProperty);
    }
}

