/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.helper.JSONData;
import com.oracle.truffle.js.builtins.helper.JSONStringifyStringNodeGen;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.List;

public abstract class JSONStringifyStringNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private PropertyGetNode getToJSONProperty;
    @Node.Child
    private JSFunctionCallNode callToJSONFunction;
    private final StringBuilderProfile stringBuilderProfile;

    protected JSONStringifyStringNode(JSContext context) {
        this.context = context;
        this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
    }

    public abstract Object execute(Object var1, String var2, DynamicObject var3);

    public static JSONStringifyStringNode create(JSContext context) {
        return JSONStringifyStringNodeGen.create(context);
    }

    @Specialization
    public Object jsonStrMain(Object jsonData, String key, DynamicObject holder) {
        try {
            assert (jsonData instanceof JSONData);
            JSONData data = (JSONData)jsonData;
            Object value = this.jsonStrPrepare(data, key, holder);
            if (!JSONStringifyStringNode.isStringifyable(value)) {
                return Undefined.instance;
            }
            StringBuilder builder = new StringBuilder();
            this.jsonStrExecute(builder, data, value);
            return this.stringBuilderProfile.toString(builder);
        }
        catch (StackOverflowError ex) {
            JSONStringifyStringNode.throwStackError();
            return null;
        }
    }

    private static boolean isStringifyable(Object value) {
        return value != Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private void jsonStrExecute(StringBuilder builder, JSONData data, Object value) {
        assert (JSONStringifyStringNode.isStringifyable(value));
        if (value == Null.instance) {
            this.stringBuilderProfile.append(builder, "null");
        } else if (value instanceof Boolean) {
            this.stringBuilderProfile.append(builder, (Boolean)value != false ? "true" : "false");
        } else if (JSRuntime.isString(value)) {
            JSONStringifyStringNode.jsonQuote(this.stringBuilderProfile, builder, value.toString());
        } else if (JSRuntime.isNumber(value)) {
            this.appendNumber(builder, (Number)value);
        } else {
            if (JSRuntime.isBigInt(value)) {
                throw Errors.createTypeError("Do not know how to serialize a BigInt");
            }
            if (JSDynamicObject.isJSDynamicObject(value) && !JSRuntime.isCallableIsJSObject((DynamicObject)value)) {
                DynamicObject valueObj = (DynamicObject)value;
                if (JSRuntime.isArray(valueObj)) {
                    this.jsonJA(builder, data, valueObj);
                } else {
                    this.jsonJO(builder, data, valueObj);
                }
            } else if (value instanceof TruffleObject) {
                assert (JSGuards.isForeignObject(value));
                this.jsonForeignObject(builder, data, value);
            } else if (JSRuntime.isJavaPrimitive(value)) {
                JSONStringifyStringNode.jsonQuote(this.stringBuilderProfile, builder, value.toString());
            } else {
                throw new RuntimeException("JSON.stringify: should never reach here, unknown type: " + value + " " + value.getClass());
            }
        }
    }

    private void jsonForeignObject(StringBuilder builder, JSONData data, Object obj) {
        InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached(obj);
        if (interop.isNull(obj)) {
            this.stringBuilderProfile.append(builder, "null");
        } else if (interop.isBoolean(obj) || interop.isString(obj) || interop.isNumber(obj)) {
            Object unboxed = JSInteropUtil.toPrimitiveOrDefault(obj, (Object)Null.instance, interop, this);
            assert (!JSGuards.isForeignObject(unboxed));
            this.jsonStrExecute(builder, data, unboxed);
        } else if (interop.hasArrayElements(obj)) {
            this.jsonJA(builder, data, obj);
        } else {
            this.jsonJO(builder, data, obj);
        }
    }

    private void appendNumber(StringBuilder builder, Number n) {
        double d = JSRuntime.doubleValue(n);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.stringBuilderProfile.append(builder, "null");
        } else if (n instanceof Integer) {
            this.stringBuilderProfile.append(builder, (Integer)n);
        } else if (n instanceof Long) {
            this.stringBuilderProfile.append(builder, (Long)n);
        } else {
            this.stringBuilderProfile.append(builder, JSRuntime.doubleToString(d));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object jsonStrPrepare(JSONData data, String key, Object holder) {
        Object value = JSDynamicObject.isJSDynamicObject(holder) ? JSObject.get((DynamicObject)holder, (Object)key) : this.truffleRead(holder, key);
        return this.jsonStrPreparePart2(data, key, holder, value);
    }

    @CompilerDirectives.TruffleBoundary
    private Object jsonStrPrepareArray(JSONData data, int key, DynamicObject holder) {
        Object value = JSObject.get(holder, (long)key);
        return this.jsonStrPreparePart2(data, String.valueOf(key), holder, value);
    }

    @CompilerDirectives.TruffleBoundary
    private Object jsonStrPrepareForeign(JSONData data, int key, Object holder) {
        assert (JSGuards.isForeignObject(holder));
        Object value = this.truffleRead(holder, key);
        return this.jsonStrPreparePart2(data, String.valueOf(key), holder, value);
    }

    private Object jsonStrPreparePart2(JSONData data, String key, Object holder, Object valueArg) {
        Object value = valueArg;
        boolean tryToJSON = false;
        if (JSRuntime.isObject(value) || JSRuntime.isBigInt(value)) {
            tryToJSON = true;
        } else if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getUncached((Object)value);
            boolean bl = tryToJSON = interop.hasMembers(value) && !interop.isNull(value) && !interop.isBoolean(value) && !interop.isString(value) && !interop.isNumber(value);
        }
        if (tryToJSON) {
            value = this.jsonStrPrepareObject(key, value);
        }
        if (data.getReplacerFnObj() != null) {
            value = JSRuntime.call(data.getReplacerFnObj(), holder, new Object[]{key, value});
        }
        if (JSDynamicObject.isJSDynamicObject(value)) {
            return JSONStringifyStringNode.jsonStrPrepareJSObject((DynamicObject)value);
        }
        if (value instanceof Symbol) {
            return Undefined.instance;
        }
        if (JSRuntime.isCallableForeign(value)) {
            return Undefined.instance;
        }
        return value;
    }

    private static Object jsonStrPrepareJSObject(DynamicObject valueObj) {
        assert (JSDynamicObject.isJSDynamicObject(valueObj)) : "JavaScript object expected, but foreign DynamicObject found";
        JSClass builtinClass = JSObject.getJSClass(valueObj);
        if (builtinClass == JSNumber.INSTANCE) {
            return JSRuntime.toNumber(valueObj);
        }
        if (builtinClass == JSBigInt.INSTANCE) {
            return JSBigInt.valueOf(valueObj);
        }
        if (builtinClass == JSString.INSTANCE) {
            return JSRuntime.toString(valueObj);
        }
        if (builtinClass == JSBoolean.INSTANCE) {
            return JSBoolean.valueOf(valueObj);
        }
        if (JSRuntime.isCallableIsJSObject(valueObj)) {
            return Undefined.instance;
        }
        return valueObj;
    }

    private Object jsonStrPrepareObject(Object key, Object value) {
        Object toJSON;
        assert (JSRuntime.isPropertyKey(key));
        if (this.getToJSONProperty == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getToJSONProperty = (PropertyGetNode)this.insert(PropertyGetNode.create("toJSON", false, this.context));
        }
        if (JSRuntime.isCallable(toJSON = this.getToJSONProperty.getValue(value))) {
            return this.jsonStrPrepareObjectFunction(key, value, toJSON);
        }
        return value;
    }

    private Object jsonStrPrepareObjectFunction(Object key, Object value, Object toJSON) {
        if (this.callToJSONFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callToJSONFunction = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.callToJSONFunction.executeCall(JSArguments.createOneArg(value, toJSON, key));
    }

    @CompilerDirectives.TruffleBoundary
    private void jsonJO(StringBuilder builder, JSONData data, Object value) {
        JSONStringifyStringNode.checkCycle(data, value);
        data.pushStack(value);
        JSONStringifyStringNode.checkStackDepth(data);
        int stepback = data.getIndent();
        int indent = data.getIndent() + 1;
        data.setIndent(indent);
        this.concatStart(builder, '{');
        boolean hasContent = data.getPropertyList() == null ? (JSDynamicObject.isJSDynamicObject(value) ? this.serializeJSONObjectProperties(builder, data, value, indent, JSObject.enumerableOwnNames((DynamicObject)value)) : this.serializeForeignObjectProperties(builder, data, value, indent)) : this.serializeJSONObjectProperties(builder, data, value, indent, data.getPropertyList());
        this.concatEnd(builder, data, stepback, '}', hasContent);
        data.popStack();
        data.setIndent(stepback);
    }

    private boolean serializeJSONObjectProperties(StringBuilder builder, JSONData data, Object value, int indent, List<? extends Object> keys) {
        boolean isFirst = true;
        boolean hasContent = false;
        for (Object object : keys) {
            String name = (String)object;
            Object strPPrepared = this.jsonStrPrepare(data, name, value);
            if (!JSONStringifyStringNode.isStringifyable(strPPrepared)) continue;
            if (isFirst) {
                this.concatFirstStep(builder, data);
                isFirst = false;
            } else {
                this.appendSeparator(builder, data, indent);
            }
            JSONStringifyStringNode.jsonQuote(this.stringBuilderProfile, builder, name);
            this.appendColon(builder, data);
            this.jsonStrExecute(builder, data, strPPrepared);
            hasContent = true;
        }
        return hasContent;
    }

    private void appendColon(StringBuilder builder, JSONData data) {
        this.stringBuilderProfile.append(builder, ':');
        if (data.getGap().length() > 0) {
            this.stringBuilderProfile.append(builder, ' ');
        }
    }

    private boolean serializeForeignObjectProperties(StringBuilder builder, JSONData data, Object obj, int indent) {
        try {
            InteropLibrary objInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached(obj);
            if (!objInterop.hasMembers(obj)) {
                return false;
            }
            Object keysObj = objInterop.getMembers(obj);
            InteropLibrary keysInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached(keysObj);
            long size = keysInterop.getArraySize(keysObj);
            boolean isFirst = true;
            boolean hasContent = false;
            for (long i = 0L; i < size; ++i) {
                Object memberValue;
                Object strPPrepared;
                String stringKey;
                Object key = keysInterop.readArrayElement(keysObj, i);
                assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                String string = stringKey = key instanceof String ? (String)key : ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asString(key);
                if (!objInterop.isMemberReadable(obj, stringKey) || !JSONStringifyStringNode.isStringifyable(strPPrepared = this.jsonStrPreparePart2(data, stringKey, obj, memberValue = this.truffleRead(obj, stringKey)))) continue;
                if (isFirst) {
                    this.concatFirstStep(builder, data);
                    isFirst = false;
                } else {
                    this.appendSeparator(builder, data, indent);
                }
                JSONStringifyStringNode.jsonQuote(this.stringBuilderProfile, builder, stringKey);
                this.appendColon(builder, data);
                this.jsonStrExecute(builder, data, strPPrepared);
                hasContent = true;
            }
            return hasContent;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "SerializeJSONObject", this);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void jsonJA(StringBuilder builder, JSONData data, Object value) {
        long length;
        Object lenObject;
        JSONStringifyStringNode.checkCycle(data, value);
        assert (JSRuntime.isArray(value) || ((InteropLibrary)InteropLibrary.getFactory().getUncached()).hasArrayElements(value));
        data.pushStack(value);
        JSONStringifyStringNode.checkStackDepth(data);
        int stepback = data.getIndent();
        int indent = data.getIndent() + 1;
        data.setIndent(indent);
        boolean isForeign = false;
        boolean isArray = false;
        if (JSDynamicObject.isJSDynamicObject(value)) {
            lenObject = JSObject.get((DynamicObject)value, (Object)"length");
            if (JSArray.isJSArray(value)) {
                isArray = true;
            }
        } else {
            lenObject = this.truffleGetSize(value);
            isForeign = true;
        }
        if ((length = JSRuntime.toLength(lenObject)) > (long)this.context.getStringLengthLimit()) {
            throw Errors.createRangeErrorInvalidStringLength();
        }
        int len = (int)length;
        this.concatStart(builder, '[');
        for (int index = 0; index < len; ++index) {
            if (index == 0) {
                this.concatFirstStep(builder, data);
            } else {
                this.appendSeparator(builder, data, indent);
            }
            Object strPPrepared = isArray ? this.jsonStrPrepareArray(data, index, (DynamicObject)value) : (isForeign ? this.jsonStrPrepareForeign(data, index, value) : this.jsonStrPrepare(data, String.valueOf(index), value));
            if (JSONStringifyStringNode.isStringifyable(strPPrepared)) {
                this.jsonStrExecute(builder, data, strPPrepared);
                continue;
            }
            this.stringBuilderProfile.append(builder, "null");
        }
        this.concatEnd(builder, data, stepback, ']', len > 0);
        data.popStack();
        data.setIndent(stepback);
    }

    private static void checkStackDepth(JSONData data) {
        if (data.stackTooDeep()) {
            JSONStringifyStringNode.throwStackError();
        }
    }

    private static void throwStackError() {
        throw Errors.createRangeError("cannot stringify objects nested that deep");
    }

    private void concatStart(StringBuilder builder, char c) {
        this.stringBuilderProfile.append(builder, c);
    }

    private void concatFirstStep(StringBuilder builder, JSONData data) {
        if (data.getGap().length() > 0) {
            this.stringBuilderProfile.append(builder, '\n');
            for (int i = 0; i < data.getIndent(); ++i) {
                this.stringBuilderProfile.append(builder, data.getGap());
            }
        }
    }

    private void concatEnd(StringBuilder builder, JSONData data, int stepback, char close, boolean hasContent) {
        if (data.getGap().length() > 0 && hasContent) {
            this.stringBuilderProfile.append(builder, '\n');
            for (int i = 0; i < stepback; ++i) {
                this.stringBuilderProfile.append(builder, data.getGap());
            }
        }
        this.stringBuilderProfile.append(builder, close);
    }

    @CompilerDirectives.TruffleBoundary
    private void appendSeparator(StringBuilder builder, JSONData data, int indent) {
        if (data.getGap().length() <= 0) {
            this.stringBuilderProfile.append(builder, ',');
        } else {
            this.stringBuilderProfile.append(builder, ",\n");
            for (int i = 0; i < indent; ++i) {
                this.stringBuilderProfile.append(builder, data.getGap());
            }
        }
    }

    private static void checkCycle(JSONData data, Object value) {
        if (data.stack.contains(value)) {
            throw Errors.createTypeError("Converting circular structure to JSON");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void jsonQuote(StringBuilderProfile stringBuilderProfile, StringBuilder builder, String value) {
        stringBuilderProfile.append(builder, '\"');
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch < ' ') {
                if (ch == '\b') {
                    stringBuilderProfile.append(builder, "\\b");
                    continue;
                }
                if (ch == '\f') {
                    stringBuilderProfile.append(builder, "\\f");
                    continue;
                }
                if (ch == '\n') {
                    stringBuilderProfile.append(builder, "\\n");
                    continue;
                }
                if (ch == '\r') {
                    stringBuilderProfile.append(builder, "\\r");
                    continue;
                }
                if (ch == '\t') {
                    stringBuilderProfile.append(builder, "\\t");
                    continue;
                }
                JSONStringifyStringNode.jsonQuoteUnicode(stringBuilderProfile, builder, ch);
                continue;
            }
            if (ch == '\\') {
                stringBuilderProfile.append(builder, "\\\\");
                continue;
            }
            if (ch == '\"') {
                stringBuilderProfile.append(builder, "\\\"");
                continue;
            }
            if (Character.isSurrogate(ch)) {
                if (Character.isHighSurrogate(ch)) {
                    char nextCh;
                    if (i + 1 < value.length() && Character.isLowSurrogate(nextCh = value.charAt(i + 1))) {
                        stringBuilderProfile.append(builder, ch);
                        stringBuilderProfile.append(builder, nextCh);
                        ++i;
                        continue;
                    }
                    JSONStringifyStringNode.jsonQuoteSurrogate(stringBuilderProfile, builder, ch);
                    continue;
                }
                JSONStringifyStringNode.jsonQuoteSurrogate(stringBuilderProfile, builder, ch);
                continue;
            }
            stringBuilderProfile.append(builder, ch);
        }
        stringBuilderProfile.append(builder, '\"');
    }

    private static void jsonQuoteUnicode(StringBuilderProfile profile, StringBuilder builder, char c) {
        profile.append(builder, "\\u00");
        profile.append(builder, Character.forDigit(c >> 4 & 0xF, 16));
        profile.append(builder, Character.forDigit(c & 0xF, 16));
    }

    private static void jsonQuoteSurrogate(StringBuilderProfile profile, StringBuilder builder, char c) {
        profile.append(builder, "\\ud");
        profile.append(builder, Character.forDigit(c >> 8 & 0xF, 16));
        profile.append(builder, Character.forDigit(c >> 4 & 0xF, 16));
        profile.append(builder, Character.forDigit(c & 0xF, 16));
    }

    private Object truffleGetSize(Object obj) {
        return JSInteropUtil.getArraySize(obj, (InteropLibrary)InteropLibrary.getFactory().getUncached(), this);
    }

    private Object truffleRead(Object obj, String key) {
        try {
            return JSRuntime.importValue(((InteropLibrary)InteropLibrary.getFactory().getUncached()).readMember(obj, key));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "readMember", key, this);
        }
    }

    private Object truffleRead(Object obj, int index) {
        try {
            return JSRuntime.importValue(((InteropLibrary)InteropLibrary.getFactory().getUncached()).readArrayElement(obj, (long)index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "readArrayElement", index, this);
        }
    }
}

