/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.JSHintSupport;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public class GlobalIsNotDefined
extends JsAstRule {
    private static final List<String> KNOWN_GLOBAL_OBJECTS = Arrays.asList("window", "document", "console", "clearInterval", "clearTimeout", "event", "frames", "history", "Image", "location", "name", "navigator", "Option", "parent", "screen", "setInterval", "setTimeout", "super", "XMLHttpRequest", "JSON", "Date", "undefined", "Math", "$", "jQuery", "Error", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError", "Array", "Object", "Boolean", "null", "Number", "RegExp", "String", "undefined", "unresolved");

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        if (!"text/javascript".equals(context.getJsParserResult().getSnapshot().getMimePath().getPath())) {
            return;
        }
        JsObject globalObject = Model.getModel((org.netbeans.modules.csl.spi.ParserResult)context.getJsParserResult(), (boolean)false).getGlobalObject();
        Collection variables = ModelUtils.getVariables((DeclarationScope)((DeclarationScope)globalObject));
        FileObject fo = context.parserResult.getSnapshot().getSource().getFileObject();
        Index jsIndex = Index.get((FileObject)fo);
        HashSet<String> namesFromFrameworks = new HashSet<String>();
        for (JsObject globalFiles : ModelUtils.getExtendingGlobalObjects((FileObject)context.getJsParserResult().getSnapshot().getSource().getFileObject())) {
            for (JsObject global : globalFiles.getProperties().values()) {
                namesFromFrameworks.add(global.getName());
            }
        }
        Collection<String> jsHintGlobalDefinition = this.findJsHintGlobalDefinition(context.getJsParserResult().getSnapshot());
        for (JsObject variable : variables) {
            String varName = variable.getName();
            if (variable.isDeclared() || KNOWN_GLOBAL_OBJECTS.contains(varName) || namesFromFrameworks.contains(varName) || jsHintGlobalDefinition.contains(varName) || variable.getJSKind() != JsElement.Kind.VARIABLE && variable.getJSKind() != JsElement.Kind.OBJECT) continue;
            if (context.isCancelled()) {
                return;
            }
            Collection findByFqn = jsIndex.findByFqn("window." + varName, new String[]{"bn"});
            if (!findByFqn.isEmpty()) continue;
            if (variable.getOccurrences().isEmpty()) {
                this.addHint(context, hints, offset, varName, variable.getOffsetRange());
                continue;
            }
            for (Occurrence occurrence : variable.getOccurrences()) {
                this.addHint(context, hints, offset, varName, occurrence.getOffsetRange());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, String name, OffsetRange range) throws BadLocationException {
        boolean add = false;
        Document document = context.getJsParserResult().getSnapshot().getSource().getDocument(false);
        if (offset > -1) {
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)document, LineDocument.class);
            if (ld != null) {
                int lineOffsetRange;
                int lineOffset = LineDocumentUtils.getLineIndex((LineDocument)ld, (int)offset);
                add = lineOffset == (lineOffsetRange = LineDocumentUtils.getLineIndex((LineDocument)ld, (int)range.getStart()));
            }
        } else {
            add = true;
            if (document != null) {
                ((AbstractDocument)document).readLock();
                try {
                    TokenSequence ts = LexerUtils.getTokenSequence((Document)document, (int)range.getStart(), (Language)JsTokenId.javascriptLanguage(), (boolean)true);
                    ts.move(range.getStart());
                    if (ts.moveNext()) {
                        add = ts.token().id() != JsTokenId.DOC_COMMENT;
                    }
                }
                finally {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
        if (add) {
            ArrayList<AddJsHintFix> fixes = new ArrayList<AddJsHintFix>();
            fixes.add(new AddJsHintFix(context.getJsParserResult().getSnapshot(), offset, name));
            hints.add(new Hint((Rule)this, Bundle.JsGlobalIsNotDefinedHintDesc(name), context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()), fixes, 500));
        }
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "jsglobalisnotdefined.hint";
    }

    public String getDescription() {
        return Bundle.JsGlobalIsNotDefinedDesc();
    }

    public String getDisplayName() {
        return Bundle.JsGlobalIsNotDefinedDN();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    private Collection<String> findJsHintGlobalDefinition(Snapshot snapshot) {
        ArrayList<String> names = new ArrayList<String>();
        Collection definedGlobal = ModelUtils.getDefinedGlobal((Snapshot)snapshot, (int)0);
        for (Identifier identifier : definedGlobal) {
            names.add(identifier.getName());
        }
        return names;
    }

    static class AddJsHintFix
    implements HintFix {
        private final Snapshot snapshot;
        private final String name;
        private int offset;

        public AddJsHintFix(Snapshot snapshot, int offset, String name) {
            this.snapshot = snapshot;
            this.name = name;
            this.offset = offset;
        }

        public String getDescription() {
            return Bundle.AddGlobalJsHint_Description(this.name);
        }

        public void implement() throws Exception {
            JSHintSupport.addGlobalInline(this.snapshot, this.offset, this.name);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

