/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib;

import org.antlr.runtime.CommonToken;
import org.netbeans.modules.css.lib.AbstractParseTreeNode;
import org.netbeans.modules.css.lib.CommonTokenUtil;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.NodeType;

public class TokenNode
extends AbstractParseTreeNode {
    private final int from;
    private final int to;
    private CssTokenId tokenId;

    public TokenNode(CharSequence source, CommonToken token) {
        super(source);
        int[] range = CommonTokenUtil.getCommonTokenOffsetRange(token);
        this.from = range[0];
        this.to = range[1];
        this.tokenId = CssTokenId.forTokenTypeCode(token.getType());
    }

    @Override
    public String name() {
        return this.image().toString();
    }

    @Override
    public NodeType type() {
        return NodeType.token;
    }

    public CssTokenId getTokenId() {
        return this.tokenId;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public int to() {
        return this.to;
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + '\'' + this.escapeNL(this.image()) + '\'' + ' ' + '[' + (Object)((Object)this.getTokenId()) + ']';
    }

    private CharSequence escapeNL(CharSequence text) {
        return text.toString().replaceAll("\n", "\\\\n");
    }
}

