/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.util.BaseUtilities;
import org.openide.util.Pair;

public final class NBJRTUtil {
    public static final String PROTOCOL = "nbjrt";
    private static final String NIO_PROVIDER = "jrt-fs.jar";
    private static final Logger LOG = Logger.getLogger(NBJRTUtil.class.getName());

    private NBJRTUtil() {
        throw new IllegalStateException("No instance allowed");
    }

    @CheckForNull
    public static URI getImageURI(@NonNull File jdkHome) {
        File jrtFsJar = NBJRTUtil.getNIOProvider(jdkHome);
        try {
            return jrtFsJar == null ? null : NBJRTUtil.createURI(jdkHome, "");
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @NonNull
    public static URI createURI(@NonNull File jdkHome, @NonNull String pathInImageFile) throws URISyntaxException {
        return new URI(String.format("%s:%s!/%s", PROTOCOL, BaseUtilities.toURI((File)jdkHome).toString(), pathInImageFile));
    }

    @CheckForNull
    public static Pair<URL, String> parseURI(@NonNull URI uri) {
        try {
            return NBJRTUtil.parseURL(uri.toURL());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @CheckForNull
    static Pair<URL, String> parseURL(@NonNull URL url) {
        if (PROTOCOL.equals(url.getProtocol())) {
            String path = url.getPath();
            int index = path.indexOf("!/");
            if (index >= 0) {
                if (!path.startsWith("file:")) {
                    throw new IllegalArgumentException(String.format("Invalid %s URI: %s", PROTOCOL, url.toExternalForm()));
                }
                String jdkPath = null;
                try {
                    jdkPath = path.substring(0, index);
                    if (jdkPath.indexOf("file://") > -1 && jdkPath.indexOf("file:////") == -1) {
                        jdkPath = jdkPath.replaceFirst("file://", "file:////");
                    }
                    URL archiveFile = new URL(jdkPath);
                    String pathInArchive = path.substring(index + 2);
                    return Pair.of((Object)archiveFile, (Object)pathInArchive);
                }
                catch (MalformedURLException mue) {
                    LOG.log(Level.WARNING, "Invalid URL ({0}): {1}, jdkHome: {2}", new Object[]{mue.getMessage(), url.toExternalForm(), jdkPath});
                }
            } else {
                LOG.log(Level.WARNING, "Invalid {0} URI: {1}", new Object[]{PROTOCOL, url});
            }
        }
        return null;
    }

    @CheckForNull
    static File getNIOProvider(@NonNull File jdkHome) {
        File jrtFsJar = new File(jdkHome, String.format("lib%s%s", File.separator, NIO_PROVIDER));
        if (jrtFsJar.exists()) {
            return jrtFsJar;
        }
        jrtFsJar = new File(jdkHome, NIO_PROVIDER);
        return jrtFsJar.exists() ? jrtFsJar : null;
    }
}

