/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BreakableNode;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.LexicalContextStatement;
import java.util.Collections;
import java.util.List;

abstract class BreakableStatement
extends LexicalContextStatement
implements BreakableNode {
    protected final Label breakLabel;

    protected BreakableStatement(int n, long l, int n2, Label label) {
        super(n, l, n2);
        this.breakLabel = label;
    }

    protected BreakableStatement(BreakableStatement breakableStatement) {
        super(breakableStatement);
        this.breakLabel = new Label(breakableStatement.getBreakLabel());
    }

    @Override
    public boolean isBreakableWithoutLabel() {
        return true;
    }

    @Override
    public Label getBreakLabel() {
        return this.breakLabel;
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(Collections.singletonList(this.breakLabel));
    }
}

