/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class PhpProjectUtils {
    public static final String USAGE_LOGGER_NAME = "org.netbeans.ui.metrics.php";
    private static final Logger LOGGER = Logger.getLogger(PhpProjectUtils.class.getName());
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.php");

    private PhpProjectUtils() {
    }

    public static PhpProject getPhpProject(Node node) {
        return PhpProjectUtils.getPhpProject(CommandUtils.getFileObject(node));
    }

    public static PhpProject getPhpProject(FileObject fo) {
        assert (fo != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        return (PhpProject)project.getLookup().lookup(PhpProject.class);
    }

    public static boolean isProject(File folder) {
        Project prj = null;
        boolean foundButBroken = false;
        try {
            prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)folder)));
        }
        catch (IOException ex) {
            foundButBroken = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (prj != null && !ProjectConvertors.isConvertorProject((Project)prj)) {
            return true;
        }
        return foundButBroken;
    }

    public static SourceGroup[] getSourceGroups(Project phpProject) {
        Sources sources = ProjectUtils.getSources((Project)phpProject);
        return sources.getSourceGroups("PHPSOURCE");
    }

    public static FileObject[] getSourceObjects(Project phpProject) {
        SourceGroup[] groups = PhpProjectUtils.getSourceGroups(phpProject);
        FileObject[] fileObjects = new FileObject[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            fileObjects[i] = groups[i].getRootFolder();
        }
        return fileObjects;
    }

    public static boolean isVisible(PhpVisibilityQuery phpVisibilityQuery, FileObject fileObject) {
        assert (phpVisibilityQuery != null);
        assert (fileObject != null);
        for (FileObject fo = fileObject; fo != null; fo = fo.getParent()) {
            if (phpVisibilityQuery.isVisible(fo)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Enum<T>> T resolveEnum(Class<T> enumClass, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (Exception exc) {
            return defaultValue;
        }
    }

    public static File resolveFile(File parentDir, String relativeFilePath) {
        if (parentDir == null) {
            throw new NullPointerException("Parameter 'parentDir' must be set");
        }
        if (StringUtils.hasText((String)relativeFilePath)) {
            return new File(parentDir, relativeFilePath.replace('/', File.separatorChar));
        }
        return parentDir;
    }

    public static void openCustomizerRun(Project project) {
        PhpProjectUtils.openCustomizer(project, "Run");
    }

    public static void openCustomizer(Project project, String category) {
        ((CustomizerProviderImpl)project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer(category, null);
    }

    public static List<Pair<Integer, Integer>> getIntervals(List<Integer> numbers) {
        if (numbers.isEmpty()) {
            return Collections.emptyList();
        }
        if (numbers.size() == 1) {
            Integer number = numbers.get(0);
            return Collections.singletonList(Pair.of((Object)number, (Object)number));
        }
        Collections.sort(numbers);
        int start = -1;
        int end = -1;
        ArrayList<Pair<Integer, Integer>> intervals = new ArrayList<Pair<Integer, Integer>>();
        for (Integer index : numbers) {
            int current = index;
            if (start == -1) {
                start = index;
            }
            if (end == -1) {
                end = index;
                continue;
            }
            if (current - end == 1) {
                end = current;
                continue;
            }
            intervals.add((Pair<Integer, Integer>)Pair.of((Object)start, (Object)end));
            start = current;
            end = current;
        }
        intervals.add(Pair.of((Object)start, (Object)end));
        return intervals;
    }

    public static boolean isInternalFile(FileObject file) {
        for (FileObject dir : CommonPhpSourcePath.getInternalPath()) {
            if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
            return true;
        }
        return false;
    }

    public static void logUsage(Class<?> srcClass, String message, List<? extends Object> params) {
        assert (message != null);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params.toArray(new Object[params.size()]));
        }
        USG_LOGGER.log(logRecord);
    }

    public static String getFrameworksForUsage(Collection<PhpFrameworkProvider> frameworks) {
        assert (frameworks != null);
        StringBuilder buffer = new StringBuilder(200);
        for (PhpFrameworkProvider provider : frameworks) {
            if (buffer.length() > 0) {
                buffer.append("|");
            }
            buffer.append(provider.getIdentifier());
        }
        return buffer.toString();
    }
}

