/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.framework.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class Frameworks {
    private static final Logger LOGGER = Logger.getLogger(Frameworks.class.getName());
    private final PhpModule phpModule;
    private final LookupListener frameworksListener = new FrameworksListener();
    private final List<PhpFrameworkProvider> frameworks = new CopyOnWriteArrayList<PhpFrameworkProvider>();
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    volatile boolean frameworksDirty = true;

    public Frameworks(PhpModule phpModule) {
        this.phpModule = phpModule;
    }

    public void projectOpened() {
        PhpFrameworks.addFrameworksListener((LookupListener)this.frameworksListener);
        this.resetFrameworks();
        this.getFrameworks();
        for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
            frameworkProvider.phpModuleOpened(this.phpModule);
        }
    }

    public void projectClosed() {
        for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
            frameworkProvider.phpModuleClosed(this.phpModule);
        }
        PhpFrameworks.removeFrameworksListener((LookupListener)this.frameworksListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpFrameworkProvider> getFrameworks() {
        if (this.phpModule.getSourceDirectory() == null) {
            return Collections.emptyList();
        }
        List<PhpFrameworkProvider> list = this.frameworks;
        synchronized (list) {
            if (this.frameworksDirty) {
                this.frameworksDirty = false;
                List allFrameworks = PhpFrameworks.getFrameworks();
                ArrayList<PhpFrameworkProvider> newFrameworks = new ArrayList<PhpFrameworkProvider>(allFrameworks.size());
                for (PhpFrameworkProvider frameworkProvider : allFrameworks) {
                    if (!frameworkProvider.isInPhpModule(this.phpModule)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Adding framework %s for project %s", frameworkProvider.getIdentifier(), this.phpModule.getName()));
                    }
                    newFrameworks.add(frameworkProvider);
                }
                this.frameworks.clear();
                this.frameworks.addAll(newFrameworks);
            }
        }
        return new ArrayList<PhpFrameworkProvider>(this.frameworks);
    }

    public void resetFrameworks() {
        this.frameworksDirty = true;
    }

    private final class FrameworksListener
    implements LookupListener {
        private FrameworksListener() {
        }

        public void resultChanged(LookupEvent ev) {
            LOGGER.fine("frameworks change, frameworks back to null");
            Frameworks.this.resetFrameworks();
            Frameworks.this.changeSupport.fireChange();
        }
    }
}

