/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

class CreateFromTemplateAttributesImpl
implements CreateFromTemplateAttributes {
    private static final Logger LOGGER = Logger.getLogger(CreateFromTemplateAttributesImpl.class.getName());
    private final AntProjectHelper helper;
    private final FileEncodingQueryImplementation encodingQuery;

    public CreateFromTemplateAttributesImpl(AntProjectHelper helper, FileEncodingQueryImplementation encodingQuery) {
        assert (helper != null);
        assert (encodingQuery != null);
        this.helper = helper;
        this.encodingQuery = encodingQuery;
    }

    public Map<String, ?> attributesFor(CreateDescriptor desc) {
        Charset charset;
        String encoding;
        String license;
        HashMap<String, String> values = new HashMap<String, String>();
        EditableProperties priv = this.helper.getProperties("nbproject/private/private.properties");
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String licensePath = priv.getProperty("project.licensePath");
        if (licensePath == null) {
            licensePath = props.getProperty("project.licensePath");
        }
        if (licensePath != null && (licensePath = this.helper.getStandardPropertyEvaluator().evaluate(licensePath)) != null) {
            File path = FileUtil.normalizeFile((File)this.helper.resolveFile(licensePath));
            if (path.exists() && path.isAbsolute()) {
                URI uri = Utilities.toURI((File)path);
                licensePath = uri.toString();
                values.put("licensePath", licensePath);
            } else {
                LOGGER.log(Level.INFO, "project.licensePath value not accepted - {0}", licensePath);
            }
        }
        if ((license = priv.getProperty("project.license")) == null) {
            license = props.getProperty("project.license");
        }
        if (license != null) {
            values.put("license", license);
        }
        String string = encoding = (charset = this.encodingQuery.getEncoding(desc.getTarget())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        try {
            Project prj = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            assert (prj != null);
            ProjectInformation info = ProjectUtils.getInformation((Project)prj);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
            values.put("webRootPath", CreateFromTemplateAttributesImpl.getWebRootPath(prj));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "", ex);
        }
        if (values.isEmpty()) {
            return null;
        }
        return Collections.singletonMap("project", values);
    }

    @CheckForNull
    private static String getWebRootPath(Project project) {
        Iterator iterator = ProjectWebRootQuery.getWebRoots((Project)project).iterator();
        if (iterator.hasNext()) {
            FileObject webRoot = (FileObject)iterator.next();
            return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)webRoot);
        }
        return null;
    }
}

