/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.foojay.api.discoclient.pkg.SemVer;
import io.foojay.api.discoclient.pkg.TermOfSupport;
import io.foojay.api.discoclient.pkg.VersionNumber;
import io.foojay.api.discoclient.util.Helper;
import java.util.ArrayList;
import java.util.List;

public class MajorVersion {
    public static final String FIELD_MAJOR_VERSION = "major_version";
    public static final String FIELD_TERM_OF_SUPPORT = "term_of_support";
    public static final String FIELD_MAINTAINED = "maintained";
    public static final String FIELD_VERSIONS = "versions";
    private List<SemVer> versions = new ArrayList<SemVer>();
    private final int majorVersion;
    private final TermOfSupport termOfSupport;
    private boolean maintained;

    public MajorVersion(int majorVersion) {
        this(majorVersion, Helper.getTermOfSupport(majorVersion));
    }

    public MajorVersion(int majorVersion, TermOfSupport termOfSupport) {
        if (majorVersion <= 0) {
            throw new IllegalArgumentException("Major version cannot be <= 0");
        }
        this.majorVersion = majorVersion;
        this.termOfSupport = termOfSupport;
        this.maintained = false;
    }

    public MajorVersion(String jsonText) {
        if (null == jsonText || jsonText.isEmpty()) {
            throw new IllegalArgumentException("json text cannot be null or empty");
        }
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        this.majorVersion = json.has(FIELD_MAJOR_VERSION) ? json.get(FIELD_MAJOR_VERSION).getAsInt() : 1;
        this.termOfSupport = json.has(FIELD_TERM_OF_SUPPORT) ? TermOfSupport.fromText(json.get(FIELD_TERM_OF_SUPPORT).getAsString()) : TermOfSupport.NOT_FOUND;
        boolean bl = this.maintained = json.has(FIELD_MAINTAINED) ? Boolean.valueOf(json.get(FIELD_MAINTAINED).toString().toLowerCase()) : false;
        if (json.has(FIELD_VERSIONS)) {
            JsonArray versionsArray = json.getAsJsonArray(FIELD_VERSIONS);
            for (JsonElement jsonElement : versionsArray) {
                this.versions.add(SemVer.fromText(jsonElement.getAsString()).getSemVer1());
            }
        }
    }

    public int getAsInt() {
        return this.majorVersion;
    }

    public TermOfSupport getTermOfSupport() {
        return this.termOfSupport;
    }

    public boolean isMaintained() {
        return this.maintained;
    }

    public List<SemVer> getVersions() {
        return this.versions;
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.majorVersion);
    }
}

