/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum LibCType implements ApiFeature
{
    GLIBC("glibc", "glibc"),
    MUSL("musl", "musl"),
    LIBC("libc", "libc"),
    C_STD_LIB("c std. lib", "c_std_lib"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private LibCType(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public LibCType getDefault() {
        return NONE;
    }

    @Override
    public LibCType getNotFound() {
        return NOT_FOUND;
    }

    public LibCType[] getAll() {
        return LibCType.values();
    }

    public static LibCType fromText(String text) {
        switch (text) {
            case "musl": 
            case "MUSL": 
            case "linux_musl": 
            case "linux-musl": 
            case "alpine_linux": 
            case "alpine": 
            case "alpine-linux": {
                return MUSL;
            }
            case "glibc": 
            case "GLIBC": 
            case "linux": 
            case "Linux": 
            case "LINUX": {
                return GLIBC;
            }
            case "c_std_lib": 
            case "C_STD_LIB": 
            case "c-std-lib": 
            case "C-STD-LIB": 
            case "windows": 
            case "Windows": 
            case "win": 
            case "Win": {
                return C_STD_LIB;
            }
            case "libc": 
            case "LIBC": 
            case "macos": 
            case "MACOS": 
            case "macosx": 
            case "MACOSX": 
            case "aix": 
            case "AIX": 
            case "qnx": 
            case "QNX": 
            case "solaris": 
            case "SOLARIS": 
            case "darwin": 
            case "DARWIN": {
                return LIBC;
            }
        }
        return NOT_FOUND;
    }

    public static List<LibCType> getAsList() {
        return Arrays.asList(LibCType.values());
    }
}

