/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        return this.isCacheReady() && this.getActionStatus(nodes) != -1;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 88532;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 88532;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes);
        switch (actionStatus) {
            case -1: 
            case 1: {
                return "popup_commit_exclude";
            }
            case 2: {
                return "popup_commit_include";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(Node[] nodes) {
        SvnModuleConfig config = SvnModuleConfig.getDefault();
        File[] files = this.getCachedContext(nodes).getFiles();
        int status = -1;
        for (int i = 0; i < files.length; ++i) {
            if (config.isExcludedFromCommit(files[i].getAbsolutePath())) {
                if (status == 1) {
                    return -1;
                }
                status = 2;
                continue;
            }
            if (status == 2) {
                return -1;
            }
            status = 1;
        }
        return status;
    }

    @Override
    public void performContextAction(final Node[] nodes) {
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

            @Override
            public void perform() {
                SvnModuleConfig config = SvnModuleConfig.getDefault();
                int status = ExcludeFromCommitAction.this.getActionStatus(nodes);
                ArrayList<File> files = new ArrayList<File>();
                for (Node node : nodes) {
                    File f;
                    File aFile = (File)node.getLookup().lookup(File.class);
                    FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
                    if (aFile != null) {
                        files.add(aFile);
                        continue;
                    }
                    if (fo == null || (f = FileUtil.toFile((FileObject)fo)) == null) continue;
                    files.add(f);
                }
                ArrayList<String> paths = new ArrayList<String>(files.size());
                for (File file : files) {
                    paths.add(file.getAbsolutePath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (status == 1) {
                    config.addExclusionPaths(paths);
                } else if (status == 2) {
                    config.removeExclusionPaths(paths);
                }
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }
}

